/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.LODE.services.accessibility;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Setup {
    String currentpath;
    String lodecfgpath;
    String startprg;
    String FS = File.separator;

    public Setup() {
        try {
            this.currentpath = new File(".").getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.checkOS()) {
            JOptionPane.showMessageDialog(null, "We are sorry. Unsupported OS");
            System.out.println("We are sorry. Unsupported OS");
            System.exit(0);
        }
        if (!this.createFiles()) {
            JOptionPane.showMessageDialog(null, "Some problems occorred when trying to write to disk");
            System.out.println("Some problems occorred when trying to write to disk");
            System.exit(1);
        }
        if (!this.startApp()) {
            JOptionPane.showMessageDialog(null, "Problem launching browser. Try yourself opening file \"files/starter.html\"");
            System.out.println("Problem launching browser. Try yourself opening file \"files/starter.html\"");
        }
    }

    private boolean createFiles() {
        try {
            if (!new File(this.lodecfgpath).exists()) {
                new File(this.lodecfgpath).mkdirs();
            }
            File lodecfg = new File(String.valueOf(this.lodecfgpath) + this.FS + "lode.cfg");
            lodecfg.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(lodecfg));
            bw.write("#Autogenerated by LODEScript\n");
            bw.write(this.currentpath);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean startApp() {
        if (!new File("." + this.FS + "files" + this.FS + "starter.html").exists()) {
            return false;
        }
        try {
            Runtime.getRuntime().exec(String.valueOf(this.startprg) + " ." + this.FS + "files" + this.FS + "starter.html");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean checkOS() {
        String osname = System.getProperty("os.name");
        if (osname.toLowerCase().contains("mac os x")) {
            this.lodecfgpath = String.valueOf(System.getenv("HOME")) + this.FS + "Library" + this.FS + "Preferences" + this.FS + "Macromedia" + this.FS + "Flash Player" + this.FS + "#Security" + this.FS + "FlashPlayerTrust";
            this.startprg = "open";
            return true;
        }
        if (osname.toLowerCase().contains("windows")) {
            this.lodecfgpath = String.valueOf(System.getenv("APPDATA")) + this.FS + "Macromedia" + this.FS + "Flash Player" + this.FS + "#Security" + this.FS + "FlashPlayerTrust";
            this.startprg = "cmd.exe /C start";
            return true;
        }
        if (osname.toLowerCase().contains("linux")) {
            this.lodecfgpath = String.valueOf(System.getenv("HOME")) + this.FS + ".macromedia" + this.FS + "Flash_Player" + this.FS + "#Security" + this.FS + "FlashPlayerTrust";
            this.startprg = "xdg-open";
            return true;
        }
        if (osname.toLowerCase().contains("freebsd")) {
            this.lodecfgpath = String.valueOf(System.getenv("HOME")) + this.FS + ".macromedia" + this.FS + "Flash_Player" + this.FS + "#Security" + this.FS + "FlashPlayerTrust";
            this.startprg = "xdg-open";
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Setup();
    }
}

