package negozio;

public class Libro
    implements Cloneable {

  protected String titolo = null;
  protected String isbn = null;
  protected float prezzo = 0;

  public Libro(String titolo, String isbn, float prezzo) {
    this.titolo = titolo;
    this.isbn = isbn;
    this.prezzo = prezzo;
  }

  public float getPrezzo() {
    return prezzo;
  }

  public void setPrezzo(float i) {
    //to do: per esercizio
  }

  public String toString() {
    return titolo + " " + isbn;
  }

  public boolean equals(Object o) {
    if (o == null) {
      return false;
    }
    if (o.getClass() != this.getClass()) {
      return false;
    }
    Libro altrolibro = (Libro) o;
    if (isbn == null && altrolibro.isbn != null) {
      return false;
    }
    if (isbn != null && !isbn.equals(altrolibro.isbn)) {
      return false;
    }
    return true;
  }

  public Object clone() {
    try {
      // shallow copy of current object
      Libro clone = (Libro)super.clone();
      // deep copy of the fields
      if (titolo != null) {
        clone.titolo = new String(titolo);
      }
      if (isbn != null) {
        clone.isbn = new String(isbn);
      }
      return clone;
    }
    catch (CloneNotSupportedException e) {
      System.out.println("Libro non puo' essere clonato!");
      return null;
    }
  }

}
