package reflect_demo;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.*;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import java.lang.reflect.Method;
import java.util.*;

public class ActiveComboBox extends javax.swing.JComboBox implements ActiveField {
  HashMap namesToValues=new HashMap();
  HashMap valuesToNames=new HashMap();
  JLabel label=new JLabel();
  ActiveFieldData afd=null;
  private int height = 20; //default height for the component
  private int width = 200; //default width for the component
  private int labelHeight = height; //default height for the label
  private int labelWidth = 80; //default width for the label
  private Method getterMethod = null;
  private Method setterMethod = null;
  private Object target = null;
  public ActiveFieldData getActiveFieldData(){return afd;}

  public ActiveComboBox(String label, String name, boolean isEditable) {
    afd=new ActiveFieldData();
    //this.addActionListener(this);
    this.addFocusListener(this);
    this.setEnabled(isEditable);
    this.label.setText(label);
    this.label.setHorizontalAlignment(JLabel.RIGHT);
    this.setName(name);
    this.setBackground(Color.WHITE);
   //this.target = target;
  }
  public int getAFType() {return ActiveFieldData.POPUPMENU;}
  public void setHeight(int h) {height=h;}
  public int getHeight(){return height;}
  public void setWidth(int w) {width=w;}
  public int getWidth(){return width;}
  public JLabel getAFLabel() {return this.label;}
  public void setLabelHeight(int h) {labelHeight=h;}
  public int getLabelHeight() {return labelHeight;}
  public void setLabelWidth(int w) {labelWidth = w;}
  public int getLabelWidth() {return labelWidth;}
  public void setSetterMethod(Method m) {setterMethod=m;}
  public void setGetterMethod(Method m) {getterMethod=m;}
  public void setTarget(Object t) { this.target=t;}
  public Object getTarget() { return target; }
  //----------------------------------------------------------------------------

  public String getText() {
    /**@todo Implement this gui.intelli.IntelliField method*/
    throw new java.lang.UnsupportedOperationException("Method getText() not yet implemented.");
   //System.out.println(super.getSelectedItem());
   //return null;
  }
  public void actionPerformed(ActionEvent e) {
    /**@todo Implement this gui.intelli.IntelliField method*/
    throw new java.lang.UnsupportedOperationException("Method actionPerformed() not yet implemented.");
  }
  public void focusGained(FocusEvent e) {
    /**@todo Implement this gui.intelli.IntelliField method*/
    System.out.println("focusGained");
  }
  public void focusLost(FocusEvent e) {
    Object selection=getSelectedItem();
    Object value=namesToValues.get(selection);
    invokeSetterMethod(value);
  }
  public void updateFieldData() {
    /**@todo Implement this gui.intelli.IntelliField method*/
    throw new java.lang.UnsupportedOperationException("Method checkText() not yet implemented.");
  }
  public boolean invokeSetterMethod(Object o) {
    Object[] a = {o};
    if (target==null) return false;
    try {
      setterMethod.invoke(target, a);
    }
    catch (Exception ex) {
      ex.printStackTrace();
      System.err.println("PROBLEM IS: "+setterMethod.toString()+" ON OBJECT "+target);
    }
    return true;
  }
  public Object invokeGetterMethod() {
    if (target==null) return null;
    Object[] a = {};
    Object result = null;
    try {
      result = getterMethod.invoke(target, a);
    }
    catch (Exception ex) {
      ex.printStackTrace();
      System.err.println("PROBLEM IS: " + getterMethod.toString() +
                         " ON OBJECT " + target);
    }
    return valuesToNames.get(result);
  }
  public void updateModelData() {
   Object name=invokeGetterMethod();
   if (name!=null) super.setSelectedItem(name);
   else { // se il Details non  inizializzato:
     super.setSelectedIndex(0); //setta il default
   }
   invokeSetterMethod(namesToValues.get(super.getSelectedItem())); //scrivi il default nel details
  }
  public void addItem(Object name,Object value) {
    super.addItem(name);
    namesToValues.put(name,value);
    valuesToNames.put(value,name);
  }
}
