package reflect_demo;

import javax.swing.JTextField;
import javax.swing.JLabel;
import java.awt.event.*;
import java.lang.reflect.*;

public class ActiveTextField
    extends JTextField
    implements ActiveField {
  ActiveFieldData afd=new ActiveFieldData();
  private String oldText = null;
  private Method getterMethod = null;
  private Method setterMethod = null;
  private Object target = null;

  public final int getAFType(){return ActiveFieldData.TEXTFIELD;}
  public ActiveFieldData getActiveFieldData(){return afd;}

  public ActiveTextField( String label, String name, boolean isEditable) {
    afd=new ActiveFieldData();
    addActionListener(this);
    addFocusListener(this);
    setEditable(isEditable);
    afd.getAfLabel().setText(label);
    afd.getAfLabel().setHorizontalAlignment(JLabel.RIGHT);
    afd.setAfName(name);
  }

  //----------------------------------------------------------------------------
  public void setSetterMethod(Method m) {setterMethod=m;}
  public void setGetterMethod(Method m) {getterMethod=m;}
  //----------------------------------------------------------------------------
  public void setTarget(Object t) {
    this.target=t;
  }
  public Object getTarget() {
   return target;
  }
  //----------------------------------------------------------------------------
  public void focusGained(FocusEvent e) {
    oldText = this.getText();
  }
  //----------------------------------------------------------------------------
  public void focusLost(FocusEvent e) {
    updateModelData();
  }
  //----------------------------------------------------------------------------
  public void actionPerformed(ActionEvent e) {
    updateModelData();
  }

  //----------------------------------------------------------------------------
  public void updateModelData() { // esegui invokeMethod solo se il testo  cambiato
    String newText = this.getText();
    if (oldText != null) {
      if (!oldText.equals(newText)) {
        this.invokeSetterMethod(newText);
      }
      oldText = newText;
    }
    else if (newText == null) {
       this.invokeSetterMethod(newText);
    }
  }

  //----------------------------------------------------------------------------
  public boolean invokeSetterMethod(Object o) {
    String s=(String)o;
    s=s.trim();
    Object[] a = {s};
    if ((setterMethod.getParameterTypes()[0]==java.lang.Integer.TYPE)||
        (setterMethod.getParameterTypes()[0]==ActiveFieldData.INTEGER_CLASS)) {
      Integer x=null;
      try {
        x = new Integer(s);
      } catch (NumberFormatException e) {
        System.err.println("String non valida in campo "+afd.getAfName());
        this.setText("DATO NON VALIDO ("+s+")");
        return false;
      }
      a[0] = x;
    } else if (setterMethod.getParameterTypes()[0]==ActiveFieldData.CHARACTER_CLASS) {
      if (s.length()>1) {
        this.setText("Stringa troppo lunga ("+s+")");
        return false;
      };
      char c=s.charAt(0);
      a[0]=new Character(c);
    } else if (setterMethod.getParameterTypes()[0]==ActiveFieldData.DATE_CLASS) {
      try {
        java.sql.Date date = java.sql.Date.valueOf(s);
        a[0] = date;
      } catch (IllegalArgumentException e) {
        this.setText("FORMATO DATA NON VALIDO ("+s+")");
        System.err.println("Data non valida in campo "+afd.getAfName());
        return false;
      }
    }
    try {
      setterMethod.invoke(target, a);
    }
    catch (Exception ex) {
      ex.printStackTrace();
      System.err.println("PROBLEM IS: "+setterMethod.toString()+" ON OBJECT "+target);
    }
    return true;
  }
  //----------------------------------------------------------------------------
  public Object invokeGetterMethod() {
    Object[] a = {};
    Object result = null;
    try {
      result = getterMethod.invoke(target, a);
    }
    catch (Exception ex) {
      ex.printStackTrace();
      System.err.println("PROBLEM IS: " + getterMethod.toString() +
                         " ON OBJECT " + target);
    }
    return result;
  }
  //----------------------------------------------------------------------------
  public void updateFieldData() {
    if (target != null) {
      Object valore = invokeGetterMethod();
      if (valore != null) {
        setText(valore.toString());
        return;
      }
    }
    setText("");
  }
}
