package reflect_demo;
import java.lang.reflect.*;
import java.util.*;

public class ListModel  {
  public Collection setOfRows = new Vector();
  protected Class[] paramsArrayV = {};
  protected Class[] paramsArrayInt = new Class[] { java.lang.Integer.TYPE};

  DataModel ud = null;
  private Class[] paramsArrayVoid = {};
 //------------------------------------------------------------------------------
  public ListModel(DataModel iud) {
    update(iud);
    Class udc=ud.getClass();
    Field[] fields=udc.getDeclaredFields();
    Method setter=null;
    Method getter=null;
    for (int i=0;i<fields.length;i++) {
      Field f=fields[i];
      String fieldName=f.getName();
      String capitalizedFieldName=Character.toUpperCase(fieldName.charAt(0))+
          fieldName.substring(1,fieldName.length());
      Class c=f.getType();
      Class[] paramsArray = new Class[]{c};
      try {
        setter = udc.getMethod("set" + capitalizedFieldName, paramsArray);
        getter = udc.getMethod("get" + capitalizedFieldName, paramsArrayVoid);
      }
      catch (SecurityException ex1) { ex1.printStackTrace();}
      catch (NoSuchMethodException ex1) {ex1.printStackTrace();}

      ActiveTextField it = new ActiveTextField(fieldName, fieldName, true);
      it.setSetterMethod(setter);
      it.setGetterMethod(getter);
      setOfRows.add(it);
    }
    loadData();
  }

  public void setTarget(ActiveField it) {
     it.setTarget(ud);
  }

 //----------------------------------------------------------------------------
 /**
  * update aggiorna i dati del modello con quelli passati, e ricarica i dati
  * nei campi
  *
  * @param iud CourseDetails
  */
 public void update(DataModel iud) {
   this.ud = iud;
   ud.deserialize();
   loadData();
 }

//------------------------------------------------------------------------------
 public void loadData() {
   Iterator iter = setOfRows.iterator();
   while (iter.hasNext()) {
     ActiveField it = (ActiveField) iter.next();
     setTarget(it);
     it.updateFieldData();
   }
 }

//------------------------------------------------------------------------------
  public void defineContent(ActiveComboBox icb) {
    icb.addItem("?", new Character('?'));
    icb.addItem("M", new Character('M'));
    icb.addItem("F", new Character('F'));
  }
}
