package reflect_demo;

import java.awt.*;
import javax.swing.*;
import java.util.*;

/**
 * <p>Title: IntelliList_View</p>
 *
 * <p>Description: </p> Pannello auto-configurante. Riceve una Hashmap di
 * IntelliField e per ciascuno di esse genera una riga contenente una JLabel ed
 * lo IntelliField setsso. Un IntelliField pu essere un IntelliTextField, un
 * IntelliPasswordField o un Intelli TextArea. Esso ha associati un oggetto O
 * (target), un metodo setter S ed un metodo getter G da eseguire su O con un
 * parametro di tipo definito in fase di creazione dell'IntelliField.
 * L'IntelliField si autoconfigura come ascoltatore dei propri eventi di fuoco e
 * di action. Quando viene modificato un campo dell'IntelliField questo richiama
 * S(parametro) su O, passando il valore del TextField come parametro. G, S e O
 * dvono essere settati sull'IntelliTextField tramite i metodi setGetterMethod,
 * setSetterMethod e setTarget.
 */
public class ListView
    extends JPanel {
  Collection setOfAF;
  GridBagLayout gridbag = new GridBagLayout();
  GridBagConstraints gbc = new GridBagConstraints();

  //-----------------------------------------------------------------------------
  public ListView(ListModel model) {
    Collection setOfAF=model.setOfRows;
    this.setLayout(gridbag);
    this.setOfAF = setOfAF;
    int size = setOfAF.size();
    JComponent jtx[] = new JComponent[size];
    JLabel lab[] = new JLabel[size];
    int seq = 0;
    //gbc.fill = GridBagConstraints.HORIZONTAL;
    gbc.anchor = GridBagConstraints.WEST;
    //gbc.weightx = 1;
    //gbc.weighty = 1;

    Iterator iter = setOfAF.iterator();
    while (iter.hasNext()) {
      ActiveField row = (ActiveField) iter.next();
      jtx[seq] = (JComponent) row;
      jtx[seq].setPreferredSize(new Dimension(row.getActiveFieldData().getWidth(),
                                              row.getActiveFieldData().getHeight()
                                              ));
      lab[seq] = row.getActiveFieldData().getAfLabel();
      lab[seq].setSize(new Dimension(100, 20));
      gbc.anchor = gbc.EAST;
      gbc.gridx = 0;
      gbc.gridy = seq;
      gridbag.setConstraints(lab[seq], gbc);
      this.add(lab[seq]);
      //
      gbc.anchor = gbc.WEST;
      gbc.gridx = 1;
      gbc.gridy = seq;
      gridbag.setConstraints(jtx[seq], gbc);
      this.add(jtx[seq]);
      seq++;
    }
  }

  //================================================================================
  public void show(int x, int y) {
    // definisci, crea e visualizza una finestra a cui  aggiunto l'IntelliList_Panel
    JFrame jf = new QuitterJFrame();
    jf.setLocation(x, y);
    jf.getContentPane().add(this);
    jf.pack();
    jf.validate();
    jf.setVisible(true);
  }

}
