package reflect_demo;

// Imports
import java.sql.Date;
import java.io.*;

public class MachineDataModel implements DataModel {
  // Fields
  private Integer machineId = null;
  private String machineName = null;

  // Constructors
  public MachineDataModel() {}

  // Methods

  public Integer getMachineId() {
   System.out.println("reading machineId");
   return machineId;
  }

  public void setMachineId(Integer machineId) {
    System.out.println("writing machineId");
    this.machineId = machineId;
    this.serialize();
  }

  public String getMachineName() {
    System.out.println("reading machineName");
    return machineName;
  }

  public void setMachineName(String name) {
    System.out.println("writing machineName");
    this.machineName = name;
    this.serialize();
  }

  public void serialize() {
    FileOutputStream fos = null;
    try {
      fos = new FileOutputStream("machine.ser");
      ObjectOutputStream oos = new ObjectOutputStream(fos);
      oos.writeObject(machineId);
      oos.writeObject(machineName);
    }
    catch (FileNotFoundException ex1) {
      ex1.printStackTrace();
    }
    catch (IOException ex) {
      ex.printStackTrace();
    }
  }

  public void deserialize() {
    FileInputStream fis = null;
    try {
      fis = new FileInputStream("machine.ser");
      ObjectInputStream oos = new ObjectInputStream(fis);
      machineId = (Integer) oos.readObject();
      machineName = (String) oos.readObject();
    }
    catch (ClassNotFoundException ex2) {
      ex2.printStackTrace();
    }
    catch (FileNotFoundException ex1) {
      System.out.println("Warning: file does not exist");
    }
    catch (IOException ex) {
      ex.printStackTrace();
    }
  }
}
