package reflect_demo;

// Imports
import java.sql.Date;
import java.io.*;

public class UserDataModel implements DataModel, Serializable {
  // Fields
  private Date dateOfBirth = null;
  private Integer userId = null;
  private String username = null;
  private Character gender = null;

  // Constructors
  public UserDataModel() {}

  // Methods
  public Date getDateOfBirth() {
    System.out.println("reading Date");
    return dateOfBirth;
  }

  public void setDateOfBirth(Date fk) {
    System.out.println("writing dateOfBirth");
    dateOfBirth = fk;
    this.serialize();
  }


  public Integer getUserId() {
   System.out.println("reading userId");
   return userId;
  }

  public void setUserId(Integer userId) {
    System.out.println("writing userId");
    this.userId = userId;
    this.serialize();
  }

  public String getUsername() {
    System.out.println("reading username");
    return username;
  }

  public void setUsername(String username) {
    System.out.println("writing username");
    this.username = username;
    this.serialize();
  }

  public Character getGender() {
    System.out.println("reading gender");
    return gender;
  }

  public void setGender(Character g) {
    System.out.println("writing gender");
    gender = g;
    this.serialize();
  }

    public void serialize() {
      FileOutputStream fos = null;
      try {
        fos = new FileOutputStream("user.ser");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this);
      }
      catch (FileNotFoundException ex1) {
        ex1.printStackTrace();
      }
      catch (IOException ex) {
        ex.printStackTrace();
      }
    }

    public void deserialize() {
      FileInputStream fis = null;
      try {
        fis = new FileInputStream("user.ser");
        ObjectInputStream oos = new ObjectInputStream(fis);
        UserDataModel ud = (UserDataModel) oos.readObject();
        this.userId=ud.getUserId();
        username=ud.getUsername();
        this.gender=ud.gender; //directly access private field!
        dateOfBirth=ud.dateOfBirth; //directly access private field!
      }
      catch (FileNotFoundException ex1) {System.out.println("Warning: file does not exist"); }
      catch (ClassNotFoundException ex2) {ex2.printStackTrace();}
      catch (IOException ex) {ex.printStackTrace();
      }
  }
}
