package distributedobjectdemo;
import java.net.Socket;
import java.net.ServerSocket;
import java.io.*;

public class Person_Skeleton extends Thread {
  PersonServer myServer;
  int port=9000;

  public Person_Skeleton(PersonServer server) {
    this.myServer=server;
  }
  public void run(){
      Socket socket = null;
      ServerSocket serverSocket=null;
      try {
         serverSocket=new ServerSocket(port);
      }
      catch (IOException ex) {
        System.err.println("error while creating serverSocket");
        ex.printStackTrace(System.err);  System.exit(1);
      }

      while (true) {
        try {
          socket=serverSocket.accept();
          System.out.println("Client opened connection");
        }
        catch (IOException ex) {
          System.err.println("error accepting on serverSocket");
          ex.printStackTrace(System.err);  System.exit(1);
        }
        try {
          while (socket!=null){
            ObjectInputStream instream=
                  new ObjectInputStream(socket.getInputStream());
            String method=(String)instream.readObject();
            if (method.equals("age")) {
              int age=myServer.getAge();
              ObjectOutputStream outstream=
                  new ObjectOutputStream(socket.getOutputStream());
              outstream.writeInt(age);
              outstream.flush();
            } else if (method.equals("name")) {
              String name=myServer.getName();
              ObjectOutputStream outstream=
                  new ObjectOutputStream(socket.getOutputStream());
              outstream.writeObject(name);
              outstream.flush();
            }
          }
        } catch (IOException ex) {
            if (ex.getMessage().equals("Connection reset")) {
              System.out.println("Client closed connection");
            } else {
              System.err.println("error on the network");
              ex.printStackTrace(System.err);   System.exit(2);
            }
          } catch (ClassNotFoundException ex) {
            System.err.println("error while reading object from the net");
            ex.printStackTrace(System.err);     System.exit(3);
          }
        }//fine del ciclo while(true)
      }  //fine del metodo run
    }    //fine della classe
