package com.titan.clients;
import com.titan.cabin.CabinRemote;
import com.titan.cabin.CabinHomeRemote;
import java.util.*;
import javax.naming.InitialContext;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;

public class Client_1 {
  public static Context getInitialContext() throws javax.naming.NamingException {
    return new InitialContext();
    /** context initialized by jndi.properties file
               Properties p = new Properties();
               p.put(Context.INITIAL_CONTEXT_FACTORY, 		  	"org.jnp.interfaces.NamingContextFactory");
     p.put(Context.URL_PKG_PREFIXES, 	"jboss.naming:org.jnp.interfaces");
               p.put(Context.PROVIDER_URL, "localhost:1099");
               return new javax.naming.InitialContext(p);
     */
  }

  public static void main(String[] args) {

    Context jndiContext = null;
    String command[] = {
        "create",
        "read",
        "update",
        "delete",
        "showContext"
    };
    // -------------------------------------------------------------------------
    if (args.length == 0) {
      System.out.println("Usage:");
      System.out.println(command[0]);
      System.out.println(command[1]);
      System.out.println(command[2] + " name");
      System.out.println(command[3]);
      System.out.println(command[4]);
      System.exit(0);
    }
    // -------------------------------------------------------------------------
    try {
      jndiContext = getInitialContext();
    }
    catch (javax.naming.NamingException ne) {
      ne.printStackTrace();
    }

    if (args[0].equals(command[4])) { //showContext        if (args[0].equals(command[0])) { //create
      try {
        java.util.Hashtable ht = jndiContext.getEnvironment();
        System.out.println("INITIAL_CONTEXT_FACTORY " +
                           ht.get(Context.INITIAL_CONTEXT_FACTORY));
        System.out.println("URL_PKG_PREFIXES        " +
                           ht.get(Context.URL_PKG_PREFIXES));
        System.out.println("PROVIDER_URL            " +
                           ht.get(Context.PROVIDER_URL));
        Iterator i = ht.keySet().iterator();
        while (i.hasNext()) {
          Object o = i.next();
          System.out.println(o + " " + ht.get(o));
        }
      }
      catch (javax.naming.NamingException ne) {
        ne.printStackTrace();
      }
      System.exit(0);
    }
    try {
      Object ref = jndiContext.lookup("CabinHandle");
      //Object ref = jndiContext.lookup("CabinEJB");
      CabinHomeRemote home = (CabinHomeRemote) PortableRemoteObject.narrow(ref,
          CabinHomeRemote.class);
      if (args[0].equals(command[0])) { //create
        CabinRemote cabin_1 = home.create(new Integer(1));
        cabin_1.setName("Master Suite");
        cabin_1.setDeckLevel(1);
        cabin_1.setShipId(1);
        cabin_1.setBedCount(3);
      }
      else if (args[0].equals(command[1])) { //read
        Integer pk = new Integer(1);
        CabinRemote cabin_2 = home.findByPrimaryKey(pk);
        System.out.println(cabin_2.getName());
        System.out.println(cabin_2.getDeckLevel());
        System.out.println(cabin_2.getShipId());
        System.out.println(cabin_2.getBedCount());
      }
      else if (args[0].equals(command[2])) { //update
        Integer pk = new Integer(1);
        CabinRemote cabin_3 = home.findByPrimaryKey(pk);
        cabin_3.setName(args[1]);
        System.out.println("Scritto: " + args[1]);
      }

      else if (args[0].equals(command[3])) { //delete
        Integer pk = new Integer(1);
        CabinRemote cabin_4 = home.findByPrimaryKey(pk);
        cabin_4.remove();
        System.out.println("Cancellato");
      }

      else {
        System.out.print("Unrecognized command: " + args[0]);
      }
    }
    catch (java.rmi.RemoteException re) {
      re.printStackTrace();
    }
    catch (javax.ejb.RemoveException re) {
      re.printStackTrace();
    }
    catch (javax.naming.NamingException ne) {
      ne.printStackTrace();
    }
    catch (javax.ejb.CreateException ce) {
      ce.printStackTrace();
    }
    catch (javax.ejb.FinderException fe) {
      fe.printStackTrace();
    }
  }
}
