/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.mail.ejb;

import com.sun.j2ee.blueprints.mail.ejb.EMailMessage;
import com.sun.j2ee.blueprints.mail.exceptions.MailerAppException;
import com.sun.j2ee.blueprints.util.tracer.Debug;
import java.util.Date;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;

public class MailHelper {
    public void createAndSendMail(EMailMessage eMailMessage) throws MailerAppException {
        try {
            String[] stringArray;
            Debug.println("Sending message\nTo: " + eMailMessage.getEmailReceiver() + "\nSubject: " + eMailMessage.getSubject() + "\nContents: " + eMailMessage.getHtmlContents());
            InitialContext initialContext = new InitialContext();
            Session session = (Session)initialContext.lookup("java:comp/env/mail/MailSession");
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom();
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)eMailMessage.getEmailReceiver(), (boolean)false));
            mimeMessage.setSubject(eMailMessage.getSubject());
            String string = "text/plain";
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            if (eMailMessage.getLocale().equals(Locale.JAPAN)) {
                stringArray = new String[]{"ja"};
                mimeMessage.setContentLanguage(stringArray);
                mimeBodyPart.setText(eMailMessage.getHtmlContents(), "iso-2022-jp");
            } else {
                mimeBodyPart.setText(eMailMessage.getHtmlContents(), "us-ascii");
            }
            mimeMessage.setHeader("X-Mailer", "JavaMailer");
            stringArray = new MimeMultipart();
            stringArray.addBodyPart((BodyPart)mimeBodyPart);
            mimeMessage.setContent((Multipart)stringArray);
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
            Debug.println("\nMail sent successfully.");
        }
        catch (Exception exception) {
            Debug.print("createAndSendMail exception : " + exception);
            throw new MailerAppException("Failure while sending mail");
        }
    }
}

