/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Available
extends Task {
    private String property;
    private String classname;
    private String file;
    private String resource;

    private boolean checkClass(String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean checkFile(String file) {
        try {
            File f = new File(file);
            return f.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkResource(String resource) {
        return ClassLoader.getSystemResource(resource) != null;
    }

    public void init() throws BuildException {
        if (this.classname != null && !this.checkClass(this.classname)) {
            return;
        }
        if (this.file != null && !this.checkFile(this.file)) {
            return;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            return;
        }
        this.project.setProperty(this.property, "true");
    }

    public void setClass(String classname) {
        this.project.log("The class attribute is deprecated. Please use the classname attribute.", 1);
        this.classname = classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setFile(String filename) {
        this.file = this.file;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

