/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Expand
extends Task {
    private String dest;
    private String source;

    public void execute() throws BuildException {
        try {
            File srcF = this.project.resolveFile(this.source);
            File dir = this.project.resolveFile(this.dest);
            this.project.log("Expanding: " + srcF + " into " + dir, 2);
            ZipInputStream zis = new ZipInputStream(new FileInputStream(srcF));
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                try {
                    File f = new File(dir, this.project.translatePath(ze.getName()));
                    this.project.log("expand-file " + ze.getName(), "expand", 3);
                    File dirF = new File(f.getParent());
                    dirF.mkdirs();
                    if (ze.isDirectory()) {
                        f.mkdirs();
                        continue;
                    }
                    byte[] buffer = new byte[1024];
                    int length = 0;
                    FileOutputStream fos = new FileOutputStream(f);
                    while ((length = zis.read(buffer)) >= 0) {
                        fos.write(buffer, 0, length);
                    }
                    fos.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("FileNotFoundException: " + ze.getName());
                }
            }
            this.project.log("</log:expand>", 3);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setDest(String d) {
        this.dest = d;
    }

    public void setSrc(String s) {
        this.source = s;
    }
}

