/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GZip
extends Task {
    private File zipFile;
    private File source;

    public void execute() throws BuildException {
        this.project.log("Building gzip: " + this.zipFile.getAbsolutePath());
        try {
            GZIPOutputStream zOut = new GZIPOutputStream(new FileOutputStream(this.zipFile));
            if (this.source.isDirectory()) {
                this.project.log("Cannot Gzip a directory!");
            } else {
                this.zipFile(this.source, zOut);
            }
            zOut.close();
        }
        catch (IOException ioe) {
            String msg = "Problem creating gzip " + ioe.getMessage();
            throw new BuildException(msg);
        }
    }

    public void setSrc(String src) {
        this.source = this.project.resolveFile(src);
    }

    public void setZipfile(String zipFilename) {
        this.zipFile = this.project.resolveFile(zipFilename);
    }

    private void zipFile(File file, GZIPOutputStream zOut) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        this.zipFile(fIn, zOut);
        fIn.close();
    }

    private void zipFile(InputStream in, GZIPOutputStream zOut) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }
}

