/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Taskdef
extends Task {
    private String name;
    private String value;

    public void init() throws BuildException {
        try {
            if (this.name == null || this.value == null) {
                String msg = "name or class attributes of taskdef element are undefined";
                throw new BuildException(msg);
            }
            try {
                Class<?> taskClass = Class.forName(this.value);
                this.project.addTaskDefinition(this.name, taskClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String msg = "taskdef class " + this.value + " cannot be found";
                throw new BuildException(msg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setClass(String v) {
        this.project.log("The class attribute is deprecated. Please use the classname attribute.", 1);
        this.value = v;
    }

    public void setClassname(String v) {
        this.value = v;
    }

    public void setName(String name) {
        this.name = name;
    }
}

