/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicRequestor {
    private TopicSession _topicSession = null;
    private Topic _topic = null;
    private TopicPublisher _requestPublisher = null;
    private TemporaryTopic _responseTopic = null;
    private TopicSubscriber _responseSubscriber = null;

    public TopicRequestor(TopicSession session, Topic topic) throws JMSException {
        this._topicSession = session;
        this._topic = topic;
        this._requestPublisher = this._topicSession.createPublisher(this._topic);
        this._responseTopic = this._topicSession.createTemporaryTopic();
        this._responseSubscriber = this._topicSession.createSubscriber(this._responseTopic);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this._responseTopic);
        this._requestPublisher.publish(message);
        return this._responseSubscriber.receive();
    }

    public void close() throws JMSException {
        this._requestPublisher.close();
        this._responseSubscriber.close();
    }
}

