/*
 * Decompiled with CFR 0.152.
 */
package webwork.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Category;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.CommandDriven;
import webwork.action.IllegalArgumentAware;
import webwork.action.ResultException;

public class ActionSupport
implements Action,
Serializable,
IllegalArgumentAware {
    protected transient Category log = Category.getInstance(this.getClass());
    protected Map errorMap;
    protected Collection errorMessages;
    protected String command;
    static /* synthetic */ Class class$java$lang$Object;

    public void addError(String fieldName, String errorMessage) {
        if (this.errorMap == null) {
            this.errorMap = new HashMap();
        }
        this.errorMap.put(fieldName, errorMessage);
    }

    public void addErrorMessage(String anErrorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
        }
        this.errorMessages.add(anErrorMessage);
    }

    public void addIllegalArgumentException(String fieldName, IllegalArgumentException e) {
        this.addError(fieldName, e.getMessage());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String doDefault() throws Exception {
        return "input";
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    protected void doValidation() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute() throws Exception {
        String string;
        long start;
        block8: {
            String string2;
            block7: {
                start = 0L;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Action executing..");
                    start = System.currentTimeMillis();
                }
                try {
                    try {
                        ResultException re;
                        if (ActionContext.getContext().getRequest() != null && (re = (ResultException)ActionContext.getContext().getRequest().getAttribute("webwork.action.ResultException")) != null) {
                            this.addErrorMessage(re.getMessage());
                            ActionContext.getContext().getRequest().removeAttribute("webwork.action.ResultException");
                            throw re;
                        }
                        if (this.command != null && !this.command.equals("") && this instanceof CommandDriven) {
                            string2 = this.invokeCommand();
                            Object var5_7 = null;
                            break block7;
                        }
                        this.validate();
                        string = this.doExecute();
                        break block8;
                    }
                    catch (ResultException e) {
                        String string3 = e.getResult();
                        Object var5_9 = null;
                        if (!this.log.isDebugEnabled()) return string3;
                        this.log.debug((Object)"Action execution done");
                        this.log.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
                        return string3;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (!this.log.isDebugEnabled()) throw throwable;
                    this.log.debug((Object)"Action execution done");
                    this.log.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
                    throw throwable;
                }
            }
            if (!this.log.isDebugEnabled()) return string2;
            this.log.debug((Object)"Action execution done");
            this.log.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
            return string2;
        }
        Object var5_8 = null;
        if (!this.log.isDebugEnabled()) return string;
        this.log.debug((Object)"Action execution done");
        this.log.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
        return string;
    }

    public Collection getErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
            return this.errorMessages;
        }
        return this.errorMessages;
    }

    public Map getErrors() {
        if (this.errorMap == null) {
            return Collections.EMPTY_MAP;
        }
        return this.errorMap;
    }

    public boolean getHasErrorMessages() {
        return this.errorMessages == null ? false : this.errorMessages.size() > 0;
    }

    public boolean getHasErrors() {
        return this.errorMap == null ? false : this.errorMap.size() > 0;
    }

    public Locale getLocale() {
        return ActionContext.getContext().getLocale();
    }

    public String getText(String aTextName) {
        Class<?> thisClass = this.getClass();
        while (true) {
            try {
                ResourceBundle bundle = this.getTexts(thisClass.getName());
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException ex) {
                MissingResourceException e = ex;
                if (!(thisClass = thisClass.getSuperclass()).equals(class$java$lang$Object != null ? class$java$lang$Object : ActionSupport.class$("java.lang.Object"))) continue;
                throw e;
            }
            break;
        }
    }

    public ResourceBundle getTexts() {
        return this.getTexts(this.getClass().getName());
    }

    public ResourceBundle getTexts(String aBundleName) {
        return ResourceBundle.getBundle(aBundleName, this.getLocale(), Thread.currentThread().getContextClassLoader());
    }

    protected boolean invalidInput() {
        return this.getHasErrorMessages() || this.getHasErrors();
    }

    protected String invokeCommand() throws Exception {
        Method method;
        StringBuffer sb = new StringBuffer("do");
        sb.append(this.command);
        sb.setCharAt(2, Character.toUpperCase(sb.charAt(2)));
        String cmd = sb.toString();
        this.log.debug((Object)("Executing action with command=" + this.command + " (mapped to method: " + cmd + ")"));
        try {
            method = this.getClass().getMethod(cmd, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No command '" + this.command + "' in action");
        }
        try {
            return (String)method.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    public boolean isCommand(String aName) {
        return this.command != null && this.command.equals(aName);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = Category.getInstance(this.getClass());
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setErrorMessages(Collection errorMessages) {
        this.errorMessages = errorMessages;
    }

    public void setErrors(Map errorMap) {
        this.errorMap = errorMap;
    }

    protected void validate() throws ResultException {
        this.doValidation();
        if (this.invalidInput()) {
            throw new ResultException("input");
        }
    }
}

