/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Category;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.config.Configuration;

public class AliasingActionFactoryProxy
extends ActionFactoryProxy {
    Map actionAliases = new Hashtable();
    boolean aliasingOnly;

    public AliasingActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
        try {
            this.aliasingOnly = Boolean.valueOf(Configuration.getString("webwork.aliasing.only"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public Action getActionImpl(String aName) throws Exception {
        String actionName = (String)this.actionAliases.get(aName);
        if (actionName == null) {
            try {
                actionName = Configuration.getString(String.valueOf(aName) + "." + Configuration.getString("webwork.action.extension"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Category.getInstance(this.getClass()).debug((Object)("Aliasing only:" + this.aliasingOnly));
                actionName = aName;
            }
            this.actionAliases.put(aName, actionName);
        }
        return this.getNextFactory().getActionImpl(actionName);
    }
}

