/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import webwork.config.DefaultConfiguration;

public abstract class Configuration {
    static Configuration configurationImpl;
    static Configuration defaultImpl;
    static Locale locale;
    static /* synthetic */ Class class$webwork$config$Configuration;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Object get(String aName) throws IllegalArgumentException {
        Object val = Configuration.getConfiguration().getImpl(aName);
        return val;
    }

    public static Configuration getConfiguration() {
        return configurationImpl == null ? Configuration.getDefaultConfiguration() : configurationImpl;
    }

    private static Configuration getDefaultConfiguration() {
        block4: {
            if (defaultImpl != null) break block4;
            defaultImpl = new DefaultConfiguration();
            try {
                String className = Configuration.getString("webwork.configuration");
                if (className.equals(defaultImpl.getClass().getName())) break block4;
                try {
                    defaultImpl = (Configuration)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                }
                catch (Exception e) {
                    Category.getInstance((Class)(class$webwork$config$Configuration != null ? class$webwork$config$Configuration : (class$webwork$config$Configuration = Configuration.class$("webwork.config.Configuration")))).error((Object)"Could not instantiate configuration", (Throwable)e);
                }
            }
            catch (IllegalArgumentException ex) {
                Category.getInstance((Class)(class$webwork$config$Configuration != null ? class$webwork$config$Configuration : (class$webwork$config$Configuration = Configuration.class$("webwork.config.Configuration")))).error((Object)"No default configuration defined", (Throwable)ex);
            }
        }
        return defaultImpl;
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        return null;
    }

    public static Locale getLocale() {
        block4: {
            if (locale != null) break block4;
            try {
                StringTokenizer localeTokens = new StringTokenizer(Configuration.getString("webwork.locale"), "_");
                String lang = null;
                String country = null;
                if (localeTokens.hasMoreTokens()) {
                    lang = localeTokens.nextToken();
                }
                if (localeTokens.hasMoreTokens()) {
                    country = localeTokens.nextToken();
                }
                locale = new Locale(lang, country);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public static String getString(String aName) throws IllegalArgumentException {
        String val = Configuration.get(aName).toString();
        return val;
    }

    public static Iterator list() {
        return Configuration.getConfiguration().listImpl();
    }

    public Iterator listImpl() {
        throw new UnsupportedOperationException("This configuration does not support listing the settings");
    }

    public static void set(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        Configuration.getConfiguration().setImpl(aName, aValue);
    }

    public static void setConfiguration(Configuration aConfig) throws IllegalStateException {
        if (configurationImpl != null) {
            throw new IllegalStateException("May only set configuration implementation once");
        }
        configurationImpl = aConfig;
        locale = null;
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration does not support updating a setting");
    }
}

