/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Category;
import webwork.util.BeanUtil;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class URLTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    protected String page;
    protected String valueAttr;
    protected String value;
    protected Map params;

    public void addParameter(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, BeanUtil.toStringValue(value));
        }
    }

    public int doEndTag() throws JspException {
        String result;
        HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)((TagSupport)this).pageContext.getResponse();
        StringBuffer link = new StringBuffer();
        if (this.value != null) {
            if (this.value.startsWith("/")) {
                link.append(request.getContextPath());
            }
            link.append(this.value);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (this.params != null && this.params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append('?');
            } else {
                link.append("&amp;");
            }
            Iterator iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    if (value instanceof String) {
                        link.append(name);
                        link.append('=');
                        link.append(URLEncoder.encode((String)value));
                    } else {
                        String[] values = (String[])value;
                        link.append(name);
                        link.append('=');
                        link.append(URLEncoder.encode(values[0]));
                    }
                }
                if (!iterator.hasNext()) continue;
                link.append("&amp;");
            }
        }
        try {
            result = response.encodeURL(link.toString());
        }
        catch (Exception exception) {
            result = link.toString();
        }
        try {
            ((TagSupport)this).pageContext.getOut().write(result);
        }
        catch (IOException _ioe) {
            throw new JspException("IOError: " + _ioe.getMessage());
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        block6: {
            if (this.page == null) {
                if (this.valueAttr != null) {
                    this.value = this.findString(this.valueAttr);
                }
            } else {
                this.value = this.page;
            }
            this.params = null;
            if (this.value != null) break block6;
            try {
                if (this.params == null) {
                    this.params = new HashMap();
                }
                this.params.putAll(((HttpServletRequest)((TagSupport)this).pageContext.getRequest()).getParameterMap());
            }
            catch (Exception e) {
                Category.getInstance(this.getClass()).warn((Object)"Unable to put request parameters into parameter map.", (Throwable)e);
            }
        }
        return 2;
    }

    public void setPage(String aName) {
        this.page = aName;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }
}

