/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.vui;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Category;
import webwork.config.Configuration;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;
import webwork.view.taglib.vui.BrowserSupport;

public abstract class AbstractVUITag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    private static Category log = Category.getInstance((Class)(class$webwork$view$taglib$vui$AbstractVUITag != null ? class$webwork$view$taglib$vui$AbstractVUITag : (class$webwork$view$taglib$vui$AbstractVUITag = AbstractVUITag.class$("webwork.view.taglib.vui.AbstractVUITag"))));
    protected String themeAttr;
    protected String theme;
    protected String templateHeaderAttr;
    protected String templateFooterAttr;
    protected Map params = new HashMap();
    static /* synthetic */ Class class$webwork$view$taglib$vui$AbstractVUITag;

    public void addParameter(String name, Object value) {
        this.addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value) {
        this.params.put(name, value);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected String constructURL(String value) {
        String result;
        HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)((TagSupport)this).pageContext.getResponse();
        StringBuffer link = new StringBuffer();
        if (value != null) {
            if (value.startsWith("/")) {
                link.append(request.getContextPath());
            }
            link.append(value);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        try {
            result = response.encodeURL(link.toString());
        }
        catch (Exception exception) {
            result = link.toString();
        }
        return result;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new JspTagException("Exception:: " + this.toString(ex));
            }
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.themeAttr != null) {
            this.theme = (String)this.findValue(this.themeAttr);
        }
        this.getStack().pushValue(this);
        try {
            try {
                String template = this.templateFooterAttr;
                if (template == null) {
                    template = this.getFooterTemplate();
                }
                IncludeTag.include(String.valueOf(this.getTemplateDirectory()) + template, ((TagSupport)this).pageContext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new JspTagException("Exception including footer: " + this.toString(ex));
            }
            Object var2_3 = null;
            this.getStack().popValue();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.getStack().popValue();
            this.params = new HashMap();
            throw throwable;
        }
        this.params = new HashMap();
        return 6;
    }

    public int doStartTag() {
        if (this.themeAttr != null) {
            this.theme = (String)this.findValue(this.themeAttr);
        }
        this.initializeAttributes();
        this.getStack().pushValue(this);
        try {
            try {
                String template = this.templateHeaderAttr;
                if (template == null) {
                    template = this.getHeaderTemplate();
                }
                IncludeTag.include(String.valueOf(this.getTemplateDirectory()) + template, ((TagSupport)this).pageContext);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                int n = 0;
                Object var3_4 = null;
                this.getStack().popValue();
                return n;
            }
            Object var3_5 = null;
            this.getStack().popValue();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.getStack().popValue();
            throw throwable;
        }
        return 1;
    }

    public String getBrowserUserAgent() {
        HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            ua = request.getHeader("user-agent");
        }
        return ua == null ? "" : ua;
    }

    public abstract String getFooterTemplate();

    public abstract String getHeaderTemplate();

    public Map getParameters() {
        return this.params;
    }

    protected void getSetParameter(String a, String n) {
        Object value;
        if (a != null && (value = this.findValue(a)) != null) {
            this.addParameterInternal(n, value);
        }
    }

    protected String getTemplateDirectory() {
        String ua = this.getBrowserUserAgent();
        return BrowserSupport.getBrowserTemplateDirectory(ua);
    }

    public String getTheme() {
        if (this.theme == null || this.theme == "") {
            this.theme = (String)((TagSupport)this).pageContext.findAttribute("theme");
        }
        if (this.theme == null || this.theme == "") {
            this.theme = Configuration.getString("webwork.ui.theme");
        }
        return this.theme;
    }

    protected abstract void initializeAttributes();

    public boolean memberOf(Object obj1, Object obj2) {
        return ContainUtil.contains(obj1, obj2);
    }

    public void setTemplateFooter(String aName) {
        this.templateFooterAttr = aName;
    }

    public void setTemplateHeader(String aName) {
        this.templateHeaderAttr = aName;
    }

    public void setTheme(String aName) {
        this.themeAttr = aName;
    }
}

