/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.wsee;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.wsee.WseeDocletTask;
import xjavadoc.XClass;
import xjavadoc.XPackage;
import xjavadoc.XTag;

public class WseeTagsHandler
extends XDocletTagSupport {
    public static final String PORT_COMPONENT = "wsee.port-component";
    public static final String HANDLER = "wsee.handler";
    public XTag currentHandler;

    public static boolean isPortComponent(XClass clazz) throws XDocletException {
        return clazz.getDoc().hasTag(PORT_COMPONENT);
    }

    public static String getNamespaceForPackage(XPackage pak) {
        return WseeTagsHandler.getNamespaceForPackage(pak.getName());
    }

    public static String getNamespaceForPackage(String pak) {
        List packageSubstitutions = WseeTagsHandler.getPackageNamespaceMappings();
        for (int i = 0; i < packageSubstitutions.size(); ++i) {
            WseeDocletTask.PackageNamespaceMapping ps = (WseeDocletTask.PackageNamespaceMapping)packageSubstitutions.get(i);
            StringTokenizer st = new StringTokenizer(ps.getPackages(), ",", false);
            while (st.hasMoreTokens()) {
                String packages = st.nextToken();
                if (!pak.startsWith(packages)) continue;
                return ps.getNamespace() + pak.substring(packages.length()).replace('.', '-');
            }
        }
        return "urn-" + pak.replace('.', '-');
    }

    public static List getPackageNamespaceMappings() {
        List packageSubstitutions = (List)DocletContext.getInstance().getConfigParam("packageNamespaceMappings");
        return packageSubstitutions;
    }

    public String getNamespaceURI(XClass clazz) throws XDocletException {
        XTag wsTag = clazz.getDoc().getTag(PORT_COMPONENT);
        String nameSpace = null;
        if (wsTag == null) {
            wsTag = clazz.getDoc().getTag("wsee.jaxrpc-mapping");
        }
        if (wsTag != null) {
            nameSpace = wsTag.getAttributeValue("namespace-uri");
        }
        if (nameSpace == null) {
            nameSpace = WseeTagsHandler.getNamespaceForPackage(clazz.getContainingPackage());
        }
        return nameSpace;
    }

    public void forAllPortComponents(String template, Properties attributes) throws XDocletException {
        Collection classes = WseeTagsHandler.getXJavaDoc().getSourceClasses();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            WseeTagsHandler.setCurrentClass((XClass)clazz);
            if (DocletSupport.isDocletGenerated((XClass)WseeTagsHandler.getCurrentClass()) || !WseeTagsHandler.isPortComponent(WseeTagsHandler.getCurrentClass())) continue;
            this.generate(template);
        }
    }

    public String serviceEndpoint(Properties props) throws XDocletException {
        XClass clazz = WseeTagsHandler.getCurrentClass();
        XTag ejbTag = clazz.getDoc().getTag("ejb.interface");
        if (ejbTag == null && (ejbTag = clazz.getDoc().getTag("web.servlet")) == null) {
            return null;
        }
        String spec = ejbTag.getAttributeValue("service-endpoint-class");
        if (spec == null || "".equals(spec)) {
            spec = clazz.getQualifiedName();
            if (spec.endsWith("Bean")) {
                spec = spec.substring(0, spec.length() - 4);
            }
            spec = spec + "Service";
        }
        return spec;
    }

    public String serviceEndpointLink(Properties props) throws XDocletException {
        XClass clazz = WseeTagsHandler.getCurrentClass();
        XTag ejbTag = clazz.getDoc().getTag("ejb.bean");
        if (ejbTag != null) {
            return "<ejb-link>" + ejbTag.getAttributeValue("name") + "</ejb-link>";
        }
        ejbTag = clazz.getDoc().getTag("web.servlet");
        if (ejbTag != null) {
            return "<servlet-link>" + ejbTag.getAttributeValue("name") + "</servlet-link>";
        }
        return null;
    }

    public String namespaceURI() throws XDocletException {
        if (WseeTagsHandler.getCurrentClass() != null) {
            return this.getNamespaceURI(WseeTagsHandler.getCurrentClass());
        }
        return WseeTagsHandler.getNamespaceForPackage(WseeTagsHandler.getCurrentPackage());
    }

    public void forAllHandlers(String template, Properties attributes) throws XDocletException {
        XClass clazz = WseeTagsHandler.getCurrentClass();
        Iterator allTags = clazz.getDoc().getTags(HANDLER).iterator();
        while (allTags.hasNext()) {
            this.currentHandler = (XTag)allTags.next();
            this.generate(template);
        }
    }

    public void ifHasHandlerTag(String template, Properties props) throws XDocletException {
        if (this.handlerTagValue(props) != null) {
            this.generate(template);
        }
    }

    public String handlerTagValue(Properties props) throws XDocletException {
        return this.currentHandler.getAttributeValue(props.getProperty("paramName"));
    }
}

