package it.patn.ursus.springursus.repository.jpa;

import it.patn.ursus.springursus.model.BankAccount;
import it.patn.ursus.springursus.model.pojo.BankAccountInfo;
import it.patn.ursus.springursus.repository.jdbc.BankTransactionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
//@Transactional(readOnly = true)
public class BankAccountJpaDAO {

        @Autowired
        private EntityManager entityManager;


        public BankAccountJpaDAO() {
        }

        public BankAccount findById(Long id) {
            return this.entityManager.find(BankAccount.class, id);
        }

        public List<BankAccountInfo> listBankAccountInfo() {
            String sql = "Select new " + BankAccountInfo.class.getName() //
                    + "(e.id,e.fullName,e.balance) " //
                    + " from " + BankAccount.class.getName() + " e ";
            Query query = entityManager.createQuery(sql, BankAccountInfo.class);
            return query.getResultList();
        }

        // MANDATORY: Transaction must be created before.
        @Transactional(propagation = Propagation.MANDATORY )
        public void addAmount(Long id, double amount) throws BankTransactionException {
            BankAccount account = this.findById(id);
            if (account == null) {
                throw new BankTransactionException("Account not found " + id);
            }
            double newBalance = account.getBalance() + amount;
            if (account.getBalance() + amount < 0) {
                throw new BankTransactionException(
                        "The money in the account '" + id + "' is not enough (" + account.getBalance() + ")");
            }
            account.setBalance(newBalance);
        }

        // Do not catch BankTransactionException in this method.
        @Transactional(propagation = Propagation.REQUIRES_NEW,
                rollbackFor = BankTransactionException.class)
        public void sendMoney(Long fromAccountId, Long toAccountId, double amount) throws BankTransactionException {

            addAmount(toAccountId, amount);
            addAmount(fromAccountId, -amount);
        }

    public List<BankAccount> findByBankAccount(String fullName) {
        TypedQuery query = this.entityManager.createQuery("select a from " + BankAccount.class.getName() + " a where a.fullName = ?1", BankAccount.class);
        query.setParameter(1, fullName);
        return query.getResultList();
    }

}