
import java.io.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;
import javax.xml.xpath.*;


public class PersonParser {
	public static void main(String[] args) throws Exception {
        File file = new File("person.xml");
    
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(file);
        
        XPathFactory factory = XPathFactory.newInstance();
	    XPath xpath = factory.newXPath();
	    XPathExpression expr = xpath.compile("/class[name/text()='Person']/attributes//field");
	    XPathExpression exprType = xpath.compile("./type/text()");
	    XPathExpression exprName = xpath.compile("./name/text()");
	    XPathExpression exprValue = xpath.compile("./value/text()");
        
        Person p = new Person();

	    NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
	    for (int i = 0; i < nodes.getLength(); i++) {
	        
            String type = ((Node)exprType.evaluate(nodes.item(i), XPathConstants.NODE)).getNodeValue();
            String attributeName = ((Node)exprName.evaluate(nodes.item(i), XPathConstants.NODE)).getNodeValue();
            String value = ((Node)exprValue.evaluate(nodes.item(i), XPathConstants.NODE)).getNodeValue();

            p.setAttribute(attributeName, type, value);
	    }
        
        System.out.println(p);
    }
}
