package com.example.hellolab;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.ByteArrayBuffer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.StrictMode;
import android.provider.MediaStore;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import android.support.v4.app.NavUtils;

public class MainActivity extends Activity {

	MediaRecorder rc;
	ByteArrayOutputStream bos;
	File audiofile;
	Button rec_button;
	File sampleDir;
	TextView msg;
	String args = "?uuid=B9AD79580CD411E2B47A434161C4589C" +
			  "&appname=HelloLab" +
              "&cmd=rawoneshot" +
              "&grammar=HelloLab" +
              "&resultFormat=emma";
	String url = "http://service.research.att.com/smm/watson" + args;
	
	String number_args = "?uuid=B9AD79580CD411E2B47A434161C4589C" +
			  "&appname=HelloLab" +
            "&cmd=rawoneshot" +
            "&grammar=digits" +
            "&resultFormat=emma";
	String number_url = "http://service.research.att.com/smm/watson" + number_args;
	
	String tts_args = "?uuid=B9AD79580CD411E2B47A434161C4589C" +
            "&voice=Crystal" +
            "&audioFormat=amr";
	String tts_url = "http://service.research.att.com/smm/tts" + tts_args;
	
	Boolean waiting_number = false;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    
        rec_button = (Button) findViewById(R.id.record_button);
        rec_button.setOnTouchListener(new View.OnTouchListener() {

			public boolean onTouch(View view, MotionEvent event) {
				if( view instanceof Button ) { 
					if( MotionEvent.ACTION_DOWN == event.getAction() ) { 
                    	try {

                    		rec_button.setPressed(true);
                    		sampleDir = new File(Environment.getExternalStorageDirectory().toString().concat("/HelloLab"));
                    		sampleDir.mkdirs();
                    	    audiofile = new File(sampleDir, "tmp.amr");

                    	    rc = new MediaRecorder();
                    	    rc.setAudioSource(MediaRecorder.AudioSource.MIC);
                    	    rc.setOutputFormat(MediaRecorder.OutputFormat.RAW_AMR);
                    	    rc.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
                    	    rc.setOutputFile(audiofile.getAbsolutePath());
                    	    rc.prepare();
                    	    rc.start();
                    	    
                		} catch (Exception e){
                			// if there is an exception print it
                			e.printStackTrace();
                		}
                            return true; 
                    } else if( MotionEvent.ACTION_UP == event.getAction() ) {
                    	try {

                    		Log.d("STOPRECORD", "Trying to stop");
                    		rec_button.setPressed(false);
                    	    rc.stop();
                    	    rc.release();
                    	    ContentValues values = new ContentValues(4);
                    	    long current = System.currentTimeMillis();
                    	    values.put(MediaStore.Audio.Media.TITLE, "audio" + audiofile.getName());
                    	    values.put(MediaStore.Audio.Media.DATE_ADDED, (int) (current / 1000));
                    	    values.put(MediaStore.Audio.Media.MIME_TYPE, "audio/3gpp");
                    	    values.put(MediaStore.Audio.Media.DATA, audiofile.getAbsolutePath());

                    	    Uri newUri = Uri.parse(audiofile.getPath());

                    	    sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, newUri));
                    	    Toast.makeText(getApplicationContext(), "Transmitting file " + newUri.toString(), Toast.LENGTH_LONG).show();
                    		
                    	    
                    	    // UPLOAD
                    	    HttpClient httpclient = new DefaultHttpClient();
                    	    HttpPost httppost;
                    	    
                    	    if (waiting_number == false) {
                    	    	httppost = new HttpPost(url);
                    	    } else { 
                    	    	httppost = new HttpPost(number_url);
                    	    }
                    	    
                            MultipartEntity entity = new MultipartEntity();

                            entity.addPart("data", new FileBody(audiofile));
                 
                            httppost.setEntity(entity);
                            ResponseHandler<String> responseHandler=new BasicResponseHandler();
                            String responseBody = httpclient.execute(httppost, responseHandler);

                            msg = (TextView) findViewById(R.id.message);
                            //msg.setText(responseBody);
                            
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder db = factory.newDocumentBuilder();
                            InputSource inStream = new InputSource();
                            inStream.setCharacterStream(new StringReader(responseBody));
                            Document doc = db.parse(inStream); 

                            Log.d("EMMA", responseBody);
                            
                            String literal = doc.getElementsByTagName("emma:literal").item(0).getChildNodes().item(0).getNodeValue();
                            
                            
                            Log.d("TEXT", literal);
                            msg.setText(literal);
                            
                            if (literal.equalsIgnoreCase("internet")) {
                            	waiting_number = false;
                            	String url = "http://www.google.it";
                            	Intent i = new Intent(android.content.Intent.ACTION_VIEW, Uri.parse(url));
            		    		startActivity(i);
                            } else if (literal.equalsIgnoreCase("map")) {
                            	waiting_number = false;
                            	String uri = "geo:46.0661739,11.150360299999988?q=Universit";
            					Intent i = new Intent(android.content.Intent.ACTION_VIEW, Uri.parse(uri));
            		    		startActivity(i);
                            } else if (literal.equalsIgnoreCase("call")) {
                            	waiting_number = true;
                            	String tts = "which number do you want to call?"; 
                                this.downloadFromUrl(tts_url+"&text="+Uri.encode(tts), "tts.amr");
                                
                                MediaPlayer mp = new MediaPlayer();
                                mp.setDataSource(sampleDir+"/tts.amr");
                                mp.prepare();
                                mp.start();
                                
                            } else if (Integer.parseInt(literal.trim()) <= 9 && Integer.parseInt(literal.trim()) >= 1) {
                            	waiting_number = false;
                            	String number = "tel://"+ literal;
                    			// create the call intent
                    		    Intent i = new Intent(Intent.ACTION_CALL, Uri.parse(number)); 
                    		    startActivity(i);
                            } else {
                            	Log.d("DEBUG", "NO MATCH");
                            }

                    	} catch (ClientProtocolException e) {
                            Log.d("[Jin]", e.getMessage(),e);
                        } catch (IOException e) {
                            Log.d("[Jin]", e.getMessage(),e);
                        } catch (Exception e) {
                    		e.printStackTrace();
                    	}
	                    return true; 
                    } 
                } 
                return false; 
			}
			
			class sendFile extends AsyncTask {

				@Override
				protected Object doInBackground(Object... arg0) {
					
					return null;
				}

			}
		
			public void downloadFromUrl(String DownloadUrl, String fileName) {

		    	   try {
		    	           File root = android.os.Environment.getExternalStorageDirectory();               

		    	           File dir = new File (root.getAbsolutePath() + "/HelloLab");
		    	           if(dir.exists()==false) {
		    	                dir.mkdirs();
		    	           }

		    	           URL url = new URL(DownloadUrl); //you can write here any link
		    	           File file = new File(dir, fileName);

		    	           long startTime = System.currentTimeMillis();
		    	           Log.d("DownloadManager", "download begining");
		    	           Log.d("DownloadManager", "download url:" + url);
		    	           Log.d("DownloadManager", "downloaded file name:" + fileName);

		    	           /* Open a connection to that URL. */
		    	           URLConnection ucon = url.openConnection();

		    	           /*
		    	            * Define InputStreams to read from the URLConnection.
		    	            */
		    	           InputStream is = ucon.getInputStream();
		    	           BufferedInputStream bis = new BufferedInputStream(is);

		    	           /*
		    	            * Read bytes to the Buffer until there is nothing more to read(-1).
		    	            */
		    	           ByteArrayBuffer baf = new ByteArrayBuffer(5000);
		    	           int current = 0;
		    	           while ((current = bis.read()) != -1) {
		    	              baf.append((byte) current);
		    	           }


		    	           /* Convert the Bytes read to a String. */
		    	           FileOutputStream fos = new FileOutputStream(file);
		    	           fos.write(baf.toByteArray());
		    	           fos.flush();
		    	           fos.close();
		    	           Log.d("DownloadManager", "download ready in" + ((System.currentTimeMillis() - startTime) / 1000) + " sec");

		    	   } catch (IOException e) {
		    	       Log.d("DownloadManager", "Error: " + e);
		    	   }

		    	}
			
		});
    
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }

    
}
