package DBUtility;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;

import com.example.lesson02_2013.R;

import Entities.Article;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

public class DBOperations {

	private SQLiteDatabase mDb;
	private DBHelper dbHelper;
//	private static String DB_PATH = null;
	private static String DB_PATH = "/data/data/com.example.lesson02_2013/databases/";
	private static final String DB_NAME = "lesson02DB.db";
	private static final int DB_VERSION = 1;

	private static DBOperations instance = null;

	private DBOperations(Context ctx) {
		dbHelper = new DBHelper(ctx, DB_NAME, null, DB_VERSION);
	}

	public static DBOperations getInstance(Context ctx) {
		if (instance == null) {
			instance = new DBOperations(ctx);
//			DB_PATH = ctx.getFilesDir().getPath()+"data/android.lesson02/databases/";
		}
		return instance; 
	}

	public void eraseDB(){
		mDb.execSQL("DROP TABLE IF EXISTS "+ Lesson02MetaData.ARTICLE_TABLE);
	}
	
	public void populateDB(Context ctx) {
		// Insert articles
		insertArticles(ctx);
	}
	
	private void insertArticles(Context ctx) {	
		Bitmap image1 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra1);
		String article1Description = "DU DEMON";
		Article a1 = new Article(article1Description, image1);
		insertArticle(a1);
		
		Bitmap image2 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra2);
		String article2Description = "GUINNES";
		Article a2 = new Article(article2Description, image2);
		insertArticle(a2);
		
		Bitmap image3 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra3);
		String article3Description = "ABBAYES DES ROCS";
		Article a3 = new Article(article3Description, image3);
		insertArticle(a3);
		
		Bitmap image4 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra4);
		String article4Description = "KOENIG LUDWIG WEISSEN";
		Article a4 = new Article(article4Description, image4);
		insertArticle(a4);
		
		Bitmap image5 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra5);
		String article5Description = "GUINNES";
		Article a5 = new Article(article5Description, image5);
		insertArticle(a5);
		
		Bitmap image6 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra6);
		String article6Description = "BIERE DES OURS";
		Article a6 = new Article(article6Description, image6);
		insertArticle(a6);
		
		Bitmap image7 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra7);
		String article7Description = "BAVARIA";
		Article a7 = new Article(article7Description, image7);
		insertArticle(a7);
		
		Bitmap image8 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra8);
		String article8Description = "DREHER";
		Article a8 = new Article(article8Description, image8);
		insertArticle(a8);
		
		Bitmap image9 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra9);
		String article9Description = "LOWENBRAU";
		Article a9 = new Article(article9Description, image9);
		insertArticle(a9);
		
		Bitmap image10 = BitmapFactory.decodeResource(ctx.getResources(),
				R.drawable.birra10);
		String article10Description = "CORONA";
		Article a10 = new Article(article10Description, image10);
		insertArticle(a10);
		
	}
	
	private void insertArticle(Article article) {
		ContentValues cv = new ContentValues();
		cv.put(Lesson02MetaData.ARTICLE_DESCRIPTION, article.getArticleName());
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		article.getImage().compress(Bitmap.CompressFormat.PNG, 100, baos);
		byte[] imageBytes = baos.toByteArray();
		cv.put(Lesson02MetaData.ARTICLE_IMAGE, imageBytes);

		mDb.insert(Lesson02MetaData.ARTICLE_TABLE, null, cv);
	}
	
	public ArrayList<Article> fetchArticle() {
		ArrayList<Article> res = new ArrayList<Article>();
		
		Cursor c = mDb.query(Lesson02MetaData.ARTICLE_TABLE, null, null, null,
				null, null, null);
		int idCol = c.getColumnIndex(Lesson02MetaData.ARTICLE_ID);
		int descCol = c.getColumnIndex(Lesson02MetaData.ARTICLE_DESCRIPTION);
		int imageCol = c.getColumnIndex(Lesson02MetaData.ARTICLE_IMAGE);
		
		if (c.moveToFirst()) {
			do {
				Article article = new Article();
				article.setId(c.getInt(idCol));
				article.setArticleName(c.getString(descCol));
				
				if (c.getBlob(imageCol) != null) {
					InputStream is = new ByteArrayInputStream(
							c.getBlob(imageCol), 0, c.getBlob(imageCol).length);
					article.setImage(BitmapFactory.decodeStream(is));
				}
				
				res.add(article);
			} while (c.moveToNext());
		}
		return res;
	}
	
	public ArrayList<Article> fetchArticleWithName(String name) {
		ArrayList<Article> res = new ArrayList<Article>();
		
		String whereClause = Lesson02MetaData.ARTICLE_DESCRIPTION + "==" + name;
		Cursor c = mDb.query(Lesson02MetaData.ARTICLE_TABLE, null, whereClause, null,
				null, null, null);
		int descCol = c.getColumnIndex(Lesson02MetaData.ARTICLE_DESCRIPTION);
		int imageCol = c.getColumnIndex(Lesson02MetaData.ARTICLE_IMAGE);
		
		if (c.moveToFirst()) {
			do {
				Article article = new Article();
				article.setArticleName(c.getString(descCol));
				
				if (c.getBlob(imageCol) != null) {
					InputStream is = new ByteArrayInputStream(
							c.getBlob(imageCol), 0, c.getBlob(imageCol).length);
					article.setImage(BitmapFactory.decodeStream(is));
				}
				
				res.add(article);
			} while (c.moveToNext());
		}
		return res;
	}
		
 	public void open() {
		mDb = dbHelper.getWritableDatabase();
	}

	public void close() {
		mDb.close();
	}
	
	public boolean checkDataBase() {
		SQLiteDatabase checkDB = null;

		try {
			
			String myPath = DB_PATH + DB_NAME;
			checkDB = SQLiteDatabase.openDatabase(myPath, null, SQLiteDatabase.OPEN_READONLY);
		} catch (SQLiteException e) {
		}
		if (checkDB != null) {
			checkDB.close();
		}
		return checkDB != null ? true : false;
	}
	
}
