package com.example.lesson02_2013;

import java.util.ArrayList;

import DBUtility.DBOperations;
import Entities.Article;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

public class ListActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.listlayout);

		Intent intent = getIntent();

		int numberOfItems = intent.getIntExtra(getPackageName() + ".items", 1);
		boolean isComplexList = intent.getBooleanExtra(getPackageName()
				+ ".isComplexList", false);

		ListView view = (ListView) findViewById(R.id.list);
		if (isComplexList) {
			DBOperations db = DBOperations.getInstance(getApplicationContext());

			db.open();
			final ArrayList<Article> articleList = db.fetchArticle();
			db.close();

			view.setAdapter(new ItemsComplexAdapter(this, R.id.list,
					articleList));
			// view.setOnItemClickListener(new OnItemClickListener() {
			//
			// public void onItemClick(AdapterView<?> parent, View view,
			// int position, long id) {
			// AlertDialog.Builder alert = new
			// AlertDialog.Builder(view.getContext());
			//
			// alert.setTitle(R.string.articleInfo);
			// alert.setMessage(getResources().getString(
			// R.string.selection)+articleList.get(position).getArticleName());
			//
			// alert.setNeutralButton(R.string.ok,
			// new DialogInterface.OnClickListener() {
			// public void onClick(DialogInterface dialog,
			// int whichButton) {
			// dialog.dismiss();
			// }
			// });
			//
			// alert.show();
			// }
			// });

			view.setOnItemClickListener(new OnItemClickListener() {

				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					// TODO Auto-generated method stub
					AlertDialog.Builder alert = new AlertDialog.Builder(
							ListActivity.this);

					alert.setTitle(R.string.articleInfo);
					alert.setMessage(getResources().getString(
							R.string.selection)
							+ articleList.get(position).getArticleName());

					alert.setNeutralButton(R.string.ok,
							new DialogInterface.OnClickListener() {
								public void onClick(DialogInterface dialog,
										int whichButton) {
									dialog.dismiss();
								}
							});

					alert.show();
				}
			});

		} else {
			ArrayList<String> articleList = PrepareStringList(numberOfItems);
			view.setAdapter(new ItemsSimpleAdapter(this, R.id.list, articleList));
		}
	}

	/**
	 * 
	 * Utility methods, we are going to use these methods in order to generate a
	 * list of items
	 * 
	 **/
	private ArrayList<Article> PrepareArticleList(int numberOfItems) {
		ArrayList<Article> articleList = new ArrayList<Article>();
		for (int i = 0; i < numberOfItems; i++) {
			Article article = new Article();
			article.setArticleName("Article " + i);

			Bitmap image = BitmapFactory.decodeResource(this.getResources(),
					R.drawable.articleimg);

			article.setImage(image);
			articleList.add(article);

		}
		return articleList;
	}

	private ArrayList<String> PrepareStringList(int numberOfItems) {
		ArrayList<String> articleList = new ArrayList<String>();
		for (int i = 0; i < numberOfItems; i++)
			articleList.add("Article " + i);

		return articleList;
	}

	/**
	 * 
	 * Adapters for our ScrollView The first one has been created using only
	 * android ready to use controls (simple_list_items_1 and text1); the second
	 * one has been customized in order to insert an image into the List.
	 * 
	 */

	private class ItemsSimpleAdapter extends ArrayAdapter<String> {

		private ArrayList<String> articles;

		public ItemsSimpleAdapter(Context context, int layoutId,
				ArrayList<String> articles) {
			super(context, layoutId, articles);
			this.articles = articles;
		}

		@Override
		public View getView(int position, View view, ViewGroup parent) {
			LayoutInflater vi = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			view = vi.inflate(android.R.layout.simple_list_item_1, null);

			String article = articles.get(position);
			TextView textView = (TextView) view
					.findViewById(android.R.id.text1);
			textView.setText(article);

			return view;
		}
	}

	private class ItemsComplexAdapter extends ArrayAdapter<Article> {

		private ArrayList<Article> articles;

		public ItemsComplexAdapter(Context context, int layoutId,
				ArrayList<Article> articles) {
			super(context, layoutId, articles);
			this.articles = articles;
		}

		@Override
		public View getView(int position, View view, ViewGroup parent) {
			LayoutInflater vi = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			view = vi.inflate(R.layout.listrowlayout, null);

			Article article = articles.get(position);

			ImageView articleImage = (ImageView) view
					.findViewById(R.id.articleImage);
			articleImage.setImageBitmap(article.getImage());

			TextView articleDescription = (TextView) view
					.findViewById(R.id.articleDesc);
			articleDescription.setText(article.getArticleName());

			return view;
		}
	}
}
