package com.example.lesson01.Adapters;

import java.util.ArrayList;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class ItemsSimpleAdapter extends ArrayAdapter<String> {

	private ArrayList<String> mArticles;
	private Context mContext = null;

	public ItemsSimpleAdapter(Context context, int layoutId,
			ArrayList<String> articles) {
		super(context, layoutId, articles);
		mArticles = articles;
		mContext = context;
	}

	@Override
	public View getView(int position, View view, ViewGroup parent) {
		LayoutInflater vi = (LayoutInflater) mContext
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		view = vi.inflate(android.R.layout.simple_list_item_1, null);

		String article = mArticles.get(position);
		TextView textView = (TextView) view.findViewById(android.R.id.text1);
		textView.setText(article);

		return view;
	}
}
