package com.example.lesson02;


import DBUtility.DBOperations;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.CompoundButton.OnCheckedChangeListener;

public class MainActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		DBOperations db = DBOperations.getInstance(getApplicationContext());
		if (!db.checkDataBase()) {
			db.open();
			db.populateDB(getApplicationContext());
			db.close();
		}

		setContentView(R.layout.activity_main);

		final CheckBox isComplexList = (CheckBox) findViewById(R.id.isComplexList);
		final EditText numberOfArticles = (EditText) findViewById(R.id.numberOfArticles);

		isComplexList.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {

				LinearLayout numberOfItemsLayout = (LinearLayout) findViewById(R.id.numberOfItemsLayout);
				if (isComplexList.isChecked())
					numberOfItemsLayout.setVisibility(View.GONE);
				else
					numberOfItemsLayout.setVisibility(View.VISIBLE);
			}
		});

		TextView startNewActivity = (TextView) findViewById(R.id.instruction4);
		startNewActivity.setOnClickListener(new OnClickListener() {

			public void onClick(View v) {
				int articlesNumber = 0;

				Intent intent = new Intent(getApplicationContext(),
						ListActivity.class);

				if (isComplexList.isChecked()) {
					intent.putExtra(getPackageName() + ".isComplexList", true);
				} else {
					try {
						articlesNumber = Integer.parseInt(numberOfArticles
								.getText().toString());

						if (articlesNumber == 0)
							articlesNumber = 1;
						if(articlesNumber > 50)
							articlesNumber = 50;

						intent.putExtra(getPackageName() + ".items",
								articlesNumber);

					} catch (NumberFormatException nfe) {
						articlesNumber = 1;
					}
				}
				startActivity(intent);
			}
		});
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

}
