package cerchicolorati;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class FinestraCerchiColorati extends Application {

    Button blu, rosso, giallo;
    Canvas canvas;
    Label circlesNrDisplay;

    private void inizializzaComponentiGrafici() {
        rosso = new Button("rosso");
        rosso.setStyle("-fx-background-color: red; -fx-text-fill: white;");
        
        blu = new Button("blu");
        blu.setStyle("-fx-background-color: rgb(0,0,255); -fx-text-fill: white;");
        
        giallo = new Button("giallo");
        giallo.setStyle("-fx-background-color: yellow; -fx-text-fill: black;");

        canvas = new Canvas();
        canvas.setHeight(300);
        canvas.setWidth(350);
        canvas.getGraphicsContext2D().setFill(Color.BEIGE);
        canvas.getGraphicsContext2D().fillRect(0, 0, canvas.getWidth(), 1);
        canvas.getGraphicsContext2D().fillRect(0, 0, 1, canvas.getHeight());
        canvas.getGraphicsContext2D().fillRect(canvas.getWidth() - 1, 0, 1, canvas.getHeight());
        canvas.getGraphicsContext2D().fillRect(0, canvas.getHeight() - 1, canvas.getWidth(), 1);

        circlesNrDisplay = new Label("Nr. 0");
        circlesNrDisplay.setStyle("-fx-font-family: Arial Narrow; -fx-text-fill: #333333;-fx-font-size: 12px; -fx-font-weight: bold; ");
    }

    private Pane doLayout() { 
        
        HBox pulsanti = new HBox();
        pulsanti.setAlignment(Pos.CENTER);
        pulsanti.setSpacing(20);
        pulsanti.setPadding(new Insets(10, 10, 10, 10));
        
        pulsanti.getChildren().add(rosso);
        pulsanti.getChildren().add(blu);
        pulsanti.getChildren().add(giallo);
        pulsanti.getChildren().add(circlesNrDisplay);
     
        BorderPane root = new BorderPane();
       
        root.setTop(pulsanti);
        root.setCenter(canvas);
   
        return root;

    }

    private void registraAscoltatori() {
        ContatoreListener incrementatoreNumero = new ContatoreListener();
        rosso.addEventHandler(ActionEvent.ACTION, incrementatoreNumero);
        blu.addEventHandler(ActionEvent.ACTION, incrementatoreNumero);
        giallo.addEventHandler(ActionEvent.ACTION, incrementatoreNumero);

        DisegnatoreCerchiListener disegnatoreCerchiRossi = new DisegnatoreCerchiListener(Color.RED, canvas);
        rosso.addEventHandler(ActionEvent.ACTION, disegnatoreCerchiRossi);

        DisegnatoreCerchiListener disegnatoreCerchiBlu = new DisegnatoreCerchiListener(Color.BLUE, canvas);
        blu.addEventHandler(ActionEvent.ACTION, disegnatoreCerchiBlu);

        DisegnatoreCerchiListener disegnatoreCerchiGialli = new DisegnatoreCerchiListener(Color.YELLOW, canvas);
        giallo.addEventHandler(ActionEvent.ACTION, disegnatoreCerchiGialli);

    }

    @Override
    public void start(Stage primaryStage) {
        inizializzaComponentiGrafici();
        registraAscoltatori();
        Pane contenuto = doLayout();
        Scene scene = new Scene(contenuto, 400, 400);
        primaryStage.setTitle("Cerchi colorati");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    class ContatoreListener implements EventHandler {

        int circlesNr = 0;

        @Override
        public void handle(Event event) {
            circlesNr++;
            circlesNrDisplay.setText("Nr. " + circlesNr);

        }
    }
}
