package pallottoliere;

import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.scene.control.Slider;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;


public class FinestraPallottoliere extends Application {

    protected Button bottoneReset;

    protected Slider sliderUnita;
    protected Slider sliderCentinaia;
    protected Slider sliderDecine;

    protected Label etichettaCentinaia;
    protected Label etichettaDecine;
    protected Label etichettaUnita;

    protected Text risultato;

    void inizializzaComponenti() {
        //creazione testo
        risultato = new Text("0");
        //impostazione colore, font e dimensione
        risultato.setFill(Color.GREENYELLOW);
        risultato.setFont(Font.font("Arial", FontWeight.BOLD, 60));
        //effetto ombra
        DropShadow ombra = new DropShadow();
        ombra.setOffsetX(3.0);
        ombra.setOffsetY(3.0);
        ombra.setColor(Color.GRAY);
        risultato.setEffect(ombra);

        //creazione selettori
        sliderUnita = new SelettoreValore();
        sliderDecine = new SelettoreValore();
        sliderCentinaia = new SelettoreValore();

        //creazionePulsante
        bottoneReset = new Button("RESET");

        //creazione labels
        etichettaCentinaia = new Label("Centinaia");
        etichettaCentinaia.setStyle("-fx-font-family: Arial Narrow; -fx-text-fill: #333333;-fx-font-size: 12px;  ");
        etichettaDecine = new Label("Decine");
        etichettaDecine.setStyle("-fx-font-family: Arial Narrow; -fx-text-fill: #333333;-fx-font-size: 12px;");
        etichettaUnita = new Label("Unita'");
        etichettaUnita.setStyle("-fx-font-family: Arial Narrow; -fx-text-fill: #333333;-fx-font-size: 12px;  ");

    }

    void creaAscoltatorePulsante() {
        bottoneReset.addEventHandler(ActionEvent.ACTION, new EventHandler<Event>() {

            @Override
            public void handle(Event event) {
                sliderCentinaia.setValue(0);
                sliderUnita.setValue(0);
                sliderDecine.setValue(0);
                aggiornaValoreNumerico();
            }
        });

    }

    protected void creaAscoltatoreSelettori() {
        //istanzia un ascoltatore di tipo ChangeListener 
        ChangeListener eh = new ChangeListener() {

            @Override
            public void changed(ObservableValue observable, 
                    Object oldValue, Object newValue) {
                aggiornaValoreNumerico();
            }
            
        };
        //registra l'ascoltatore sulla proprieta' valore 
        //dei tre selettori
        sliderCentinaia.valueProperty().addListener(eh);
        sliderDecine.valueProperty().addListener(eh);
        sliderUnita.valueProperty().addListener(eh);
    }

    protected Pane doLayout() {
        BorderPane root = new BorderPane();

        //sud
        HBox areaBottoni = new HBox();
        //spaziatura dei componenti dal bordo
        areaBottoni.setPadding(new Insets(10));
        //l'area ha la larghezza massima 
        areaBottoni.setMaxWidth(Double.MAX_VALUE);
        //allineamento dei componenti
        areaBottoni.setAlignment(Pos.CENTER);
        //aggiunta pulsante
        areaBottoni.getChildren().add(bottoneReset);

        //centro
        GridPane griglia = new GridPane();
        //spaziatura
        griglia.setHgap(10);
        griglia.setVgap(20);
        griglia.setPadding(new Insets(20));
        //impostazione righe e colonne
        //prima colonna
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHalignment(HPos.CENTER);
        cc.setPercentWidth(20);
        griglia.getColumnConstraints().add(cc);
        //seconda colonna
        cc = new ColumnConstraints();
        cc.setHalignment(HPos.CENTER);
        cc.setPercentWidth(20);
        griglia.getColumnConstraints().add(cc);
        //terza colonna
        cc = new ColumnConstraints();
        cc.setHalignment(HPos.CENTER);
        cc.setPercentWidth(20);
        griglia.getColumnConstraints().add(cc);
        //quarta colonna
        cc = new ColumnConstraints();
        cc.setHalignment(HPos.CENTER);
        cc.setPercentWidth(40);
        griglia.getColumnConstraints().add(cc);
        //prima riga
        RowConstraints rc = new RowConstraints();
        rc.setFillHeight(true);
        rc.setPercentHeight(90);
        rc.setValignment(VPos.CENTER);
        griglia.getRowConstraints().add(rc);
        //seconda riga
        rc = new RowConstraints();
        rc.setFillHeight(true);
        rc.setPercentHeight(10);
        rc.setValignment(VPos.CENTER);
        griglia.getRowConstraints().add(rc);

        //aggiunta dei componenti
        griglia.add(sliderCentinaia, 0, 0);
        griglia.add(sliderDecine, 1, 0);
        griglia.add(sliderUnita, 2, 0);
        griglia.add(etichettaCentinaia, 0, 1);
        griglia.add(etichettaDecine, 1, 1);
        griglia.add(etichettaUnita, 2, 1);
        griglia.add(risultato, 3, 0, 1, 2);

        root.setCenter(griglia);
        root.setBottom(areaBottoni);

        return root;
    }

    
    @Override
    public void start(Stage primaryStage) {

        inizializzaComponenti();

        creaAscoltatorePulsante();
        creaAscoltatoreSelettori();

        Pane root = doLayout();

        Scene scene = new Scene(root, 500, 300);

        primaryStage.setTitle("Pallottoliere");
        primaryStage.setScene(scene);

        primaryStage.show();
    }

    
    protected void aggiornaValoreNumerico() {
        //legge i valori correnti dei tre selettori
        double cent = sliderCentinaia.getValue();
        double dec = sliderDecine.getValue();
        double unit = sliderUnita.getValue();
        //calcola il risultato
        int numero = (int) (unit + (10 * dec) + (100 * cent));
        //lo visualizza sul componente testo
        risultato.setText("" + numero);
    }

}
