package com.example.lesson01.Adapters;

import java.util.ArrayList;

import com.example.lesson01.Article;
import com.example.lesson01.R;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ItemsComplexAdapter extends ArrayAdapter<Article> {

	private ArrayList<Article> mArticles;
	private Context mContext = null;

	public ItemsComplexAdapter(Context context, int layoutId,
			ArrayList<Article> articles) {
		super(context, layoutId, articles);
		mArticles = articles;
		mContext = context;
	}


	@Override
	public View getView(int position, View view, ViewGroup parent) {
		LayoutInflater vi = (LayoutInflater) mContext
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		view = vi.inflate(R.layout.listrowlayout, null);

		Article article = mArticles.get(position);

		ImageView articleImage = (ImageView) view
				.findViewById(R.id.articleImage);
		articleImage.setImageBitmap(article.getImage());

		TextView articleDescription = (TextView) view
				.findViewById(R.id.articleDesc);
		articleDescription.setText(article.getArticleName());

		return view;
	}
}
