package com.example.lesson01;

import java.util.ArrayList;

import com.example.lesson01.Adapters.ItemsComplexAdapter;
import com.example.lesson01.Adapters.ItemsSimpleAdapter;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;



public class ListActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.listlayout);

		// retrieve the intent that started the current activity
		Intent intent = getIntent();

		String passedParameter = intent.getStringExtra(getPackageName()+ ".insertedText");
		
		int numberOfItems = intent.getIntExtra(getPackageName() + ".items", 1);
		boolean isComplexList = intent.getBooleanExtra(getPackageName()	+ ".isComplexList", false);

		TextView passedText = (TextView) findViewById(R.id.passedString);
		passedText.setText(R.string.welcome);
		passedText.append(" " + passedParameter);

		ListView view = (ListView) findViewById(R.id.list);
		
		if (isComplexList) {

			//Show the images for each beer!
			final ArrayList<Article> articleList = PrepareArticleList(numberOfItems);
			view.setAdapter(new ItemsComplexAdapter(this, R.id.list,
					articleList));
			view.setOnItemClickListener(new OnItemClickListener() {

				public void onItemClick(AdapterView<?> parent, View view,int position, long id) {
					Toast.makeText(getApplicationContext(),
							articleList.get(position).getArticleName(),
							Toast.LENGTH_LONG).show();
				}
			});

		} else {
			//Show only the names
			ArrayList<String> articleList = PrepareStringList(numberOfItems);
			view.setAdapter(new ItemsSimpleAdapter(this, R.layout.listrowlayout, articleList));
		}
	}


	/**
	 * 
	 * Utility methods, we are going to use these methods in order to generate a
	 * list of items
	 * 
	 **/
	private ArrayList<Article> PrepareArticleList(int numberOfItems) {
		ArrayList<Article> articleList = new ArrayList<Article>();
		for (int i = 0; i < numberOfItems; i++) {
			Article article = new Article();
			article.setArticleName("Article " + i);

			Bitmap image = BitmapFactory.decodeResource(this.getResources(),
					R.drawable.articleimg);

			article.setImage(image);
			articleList.add(article);

		}
		return articleList;
	}

	private ArrayList<String> PrepareStringList(int numberOfItems) {
		ArrayList<String> articleList = new ArrayList<String>();
		for (int i = 0; i < numberOfItems; i++)
			articleList.add("Article " + i);

		return articleList;
	}



}
