/*
 * Decompiled with CFR 0.152.
 */
package animation;

import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PathTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Animation
extends Application {
    private SequentialTransition sequentialTransition;
    private SequentialTransition parallelTransition;

    public void start(Stage stage) {
        stage.setTitle("Transitions and Timeline Animation");
        Scene scene = new Scene((Parent)new Group(), 600.0, 450.0);
        scene.setFill((Paint)Color.WHITE);
        Rectangle rectBasicTimeline = new Rectangle(100.0, 50.0, 100.0, 50.0);
        rectBasicTimeline.setFill((Paint)Color.BROWN);
        Rectangle rectFade = new Rectangle(10.0, 150.0, 100.0, 100.0);
        rectFade.setArcHeight(20.0);
        rectFade.setArcWidth(20.0);
        rectFade.setFill((Paint)Color.RED);
        Rectangle rectFadeAll = new Rectangle(0.0, 0.0, 600.0, 450.0);
        rectFadeAll.setFill((Paint)Color.GREY);
        Rectangle rectPath = new Rectangle(0.0, 0.0, 40.0, 40.0);
        rectPath.setArcHeight(10.0);
        rectPath.setArcWidth(10.0);
        rectPath.setFill((Paint)Color.ORANGE);
        Rectangle rectParallel = new Rectangle(10.0, 200.0, 50.0, 50.0);
        rectParallel.setArcHeight(15.0);
        rectParallel.setArcWidth(15.0);
        rectParallel.setFill((Paint)Color.DARKBLUE);
        rectParallel.setTranslateX(50.0);
        rectParallel.setTranslateY(75.0);
        Rectangle rectSeq = new Rectangle(25.0, 25.0, 50.0, 50.0);
        rectSeq.setArcHeight(15.0);
        rectSeq.setArcWidth(15.0);
        rectSeq.setFill((Paint)Color.DARKBLUE);
        rectSeq.setTranslateX(50.0);
        rectSeq.setTranslateY(50.0);
        ((Group)scene.getRoot()).getChildren().addAll((Object[])new Node[]{rectBasicTimeline, rectFade, rectPath, rectParallel, rectSeq});
        stage.setScene(scene);
        stage.show();
        Timeline timeline = new Timeline();
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(true);
        KeyValue kv = new KeyValue((WritableValue)rectBasicTimeline.xProperty(), (Object)300, Interpolator.EASE_BOTH);
        KeyFrame kf = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.play();
        FadeTransition ft = new FadeTransition(Duration.millis((double)3000.0), (Node)rectFade);
        ft.setFromValue(1.0);
        ft.setToValue(0.1);
        ft.setCycleCount(-1);
        ft.setAutoReverse(true);
        ft.play();
        Path path = new Path();
        path.getElements().add((Object)new MoveTo(20.0, 20.0));
        path.getElements().add((Object)new CubicCurveTo(380.0, 0.0, 380.0, 120.0, 200.0, 120.0));
        path.getElements().add((Object)new CubicCurveTo(0.0, 120.0, 0.0, 240.0, 380.0, 240.0));
        PathTransition pathTransition = new PathTransition();
        pathTransition.setDuration(Duration.millis((double)4000.0));
        pathTransition.setPath((Shape)path);
        pathTransition.setNode((Node)rectPath);
        pathTransition.setOrientation(PathTransition.OrientationType.ORTHOGONAL_TO_TANGENT);
        pathTransition.setCycleCount(-1);
        pathTransition.setAutoReverse(true);
        pathTransition.play();
        FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)1000.0), (Node)rectSeq);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue((double)0.3f);
        fadeTransition.setCycleCount(1);
        fadeTransition.setAutoReverse(true);
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)2000.0), (Node)rectSeq);
        translateTransition.setFromX(50.0);
        translateTransition.setToX(375.0);
        translateTransition.setCycleCount(1);
        translateTransition.setAutoReverse(true);
        RotateTransition rotateTransition = new RotateTransition(Duration.millis((double)2000.0), (Node)rectSeq);
        rotateTransition.setByAngle(180.0);
        rotateTransition.setCycleCount(4);
        rotateTransition.setAutoReverse(true);
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)2000.0), (Node)rectSeq);
        scaleTransition.setFromX(1.0);
        scaleTransition.setFromY(1.0);
        scaleTransition.setToX(2.0);
        scaleTransition.setToY(2.0);
        scaleTransition.setCycleCount(1);
        scaleTransition.setAutoReverse(true);
        this.sequentialTransition = new SequentialTransition();
        this.sequentialTransition.getChildren().addAll((Object[])new javafx.animation.Animation[]{fadeTransition, translateTransition, rotateTransition, scaleTransition});
        this.sequentialTransition.setCycleCount(-1);
        this.sequentialTransition.setAutoReverse(true);
        this.sequentialTransition.play();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

