/*
 * Decompiled with CFR 0.152.
 */
package miniDI.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import miniDI.framework.annotations.Pair;
import miniDI.framework.annotations.Pairs;
import miniDI.framework.annotations.ServiceDeclarationPackage;
import miniDI.framework.annotations.ServiceImplementationPackage;

@ServiceDeclarationPackage
public abstract class AbstractConfigurator {
    private Map<Class<?>, Class<?>> classMap = new HashMap();

    protected AbstractConfigurator() {
        Pair[] coppie;
        ServiceDeclarationPackage sd = this.getClass().getAnnotation(ServiceDeclarationPackage.class);
        ServiceImplementationPackage si = this.getClass().getAnnotation(ServiceImplementationPackage.class);
        String serviceDeclarationPackage = sd.value() + ".";
        String serviceImplementationPackage = si.value() + ".";
        Pairs p = this.getClass().getAnnotation(Pairs.class);
        for (Pair c : coppie = p.value()) {
            String key = serviceDeclarationPackage + c.key();
            String value = serviceImplementationPackage + c.value();
            Class<?> keyClass = null;
            Class<?> valueClass = null;
            try {
                keyClass = Class.forName(key);
                valueClass = Class.forName(value);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.createMapping(keyClass, valueClass);
        }
    }

    private <T> void createMapping(Class<T> baseClass, Class<? extends T> subClass) {
        this.classMap.put(baseClass, subClass.asSubclass(baseClass));
    }

    <T> Class<? extends T> getMapping(Class<T> type) {
        Class<?> implementation = this.classMap.get(type);
        if (implementation == null) {
            throw new IllegalArgumentException("Couldn't find the mapping for : " + type);
        }
        return implementation;
    }
}

