/*
 * Decompiled with CFR 0.152.
 */
package miniDI.framework;

import java.lang.reflect.Constructor;
import miniDI.framework.AbstractConfigurator;
import miniDI.framework.annotations.Inject;

public class MiniDIFramework {
    private AbstractConfigurator module;

    MiniDIFramework(AbstractConfigurator module) {
        this.module = module;
    }

    public Object injectDependencies(Class klass) throws Exception {
        if (klass != null) {
            boolean flag = true;
            int index = 0;
            for (Constructor<?> constructor : klass.getConstructors()) {
                if (!constructor.isAnnotationPresent(Inject.class) || !flag || index != 0) continue;
                flag = false;
                ++index;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                Object[] objArr = new Object[parameterTypes.length];
                int i = 0;
                for (Class<?> c : parameterTypes) {
                    Class<?> dependency = this.module.getMapping(c);
                    if (!c.isAssignableFrom(dependency)) continue;
                    objArr[i++] = dependency.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                Object resObj = klass.getConstructor(parameterTypes).newInstance(objArr);
                return resObj;
            }
        }
        return null;
    }
}

