/*
 * Decompiled with CFR 0.152.
 */
package miniDI.framework;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import miniDI.framework.annotations.Pair;
import miniDI.framework.annotations.Pairs;
import miniDI.framework.annotations.ServiceDeclarationPackage;
import miniDI.framework.annotations.ServiceImplementationPackage;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ServiceDeclarationPackage
public abstract class AbstractConfigurator {
    private Map<Class<?>, Class<?>> classMap = new HashMap();

    protected AbstractConfigurator() {
        File xml = new File("miniDI.xml");
        if (xml.exists()) {
            this.configureWithXML(xml);
        } else {
            this.configureWithAnnotations();
        }
    }

    private void configureWithAnnotations() {
        Pair[] coppie;
        ServiceDeclarationPackage sd = this.getClass().getAnnotation(ServiceDeclarationPackage.class);
        String serviceDeclarationPackage = sd.value() + ".";
        ServiceImplementationPackage si = this.getClass().getAnnotation(ServiceImplementationPackage.class);
        String serviceImplementationPackage = si.value() + ".";
        Pairs p = this.getClass().getAnnotation(Pairs.class);
        for (Pair c : coppie = p.value()) {
            String key = serviceDeclarationPackage + c.key();
            String value = serviceImplementationPackage + c.value();
            Class<?> keyClass = null;
            Class<?> valueClass = null;
            try {
                keyClass = Class.forName(key);
                valueClass = Class.forName(value);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.createMapping(keyClass, valueClass);
        }
    }

    private void configureWithXML(File xmlFile) {
        Pair[] coppie;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            doc = builder.parse(xmlFile.getAbsolutePath());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Object result = null;
        try {
            XPathExpression expr = xpath.compile("/miniDI/Pairs/Pair");
            result = expr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        NodeList nodes = (NodeList)result;
        for (int i = 0; i < nodes.getLength(); ++i) {
            System.out.println(nodes.item(i).getNodeValue());
        }
        System.exit(1);
        ServiceDeclarationPackage sd = this.getClass().getAnnotation(ServiceDeclarationPackage.class);
        String serviceDeclarationPackage = sd.value() + ".";
        ServiceImplementationPackage si = this.getClass().getAnnotation(ServiceImplementationPackage.class);
        String serviceImplementationPackage = si.value() + ".";
        Pairs p = this.getClass().getAnnotation(Pairs.class);
        for (Pair c : coppie = p.value()) {
            String key = serviceDeclarationPackage + c.key();
            String value = serviceImplementationPackage + c.value();
            Class<?> keyClass = null;
            Class<?> valueClass = null;
            try {
                keyClass = Class.forName(key);
                valueClass = Class.forName(value);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.createMapping(keyClass, valueClass);
        }
    }

    private <T> void createMapping(Class<T> baseClass, Class<? extends T> subClass) {
        this.classMap.put(baseClass, subClass.asSubclass(baseClass));
    }

    <T> Class<? extends T> getMapping(Class<T> type) {
        Class<?> implementation = this.classMap.get(type);
        if (implementation == null) {
            throw new IllegalArgumentException("Couldn't find the mapping for : " + type);
        }
        return implementation;
    }
}

