/*
 * Decompiled with CFR 0.152.
 */
package miniDI.framework;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import miniDI.framework.annotations.Pair;
import miniDI.framework.annotations.Pairs;
import miniDI.framework.annotations.ServiceDeclarationPackage;
import miniDI.framework.annotations.ServiceImplementationPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ServiceDeclarationPackage
public abstract class AbstractConfigurator {
    private Map<Class<?>, Class<?>> classMap = new HashMap();

    protected AbstractConfigurator() {
        File xml = new File("miniDI.xml");
        System.out.println("looking for file " + xml.getAbsolutePath() + "...");
        if (xml.exists()) {
            System.out.println("...found. Proceeding with XML configuration");
            this.configureWithXML(xml);
        } else {
            System.out.println("...not found. Proceeding with annotation configuration");
            this.configureWithAnnotations();
        }
    }

    private void configureWithAnnotations() {
        Pair[] coppie;
        ServiceDeclarationPackage sd = this.getClass().getAnnotation(ServiceDeclarationPackage.class);
        ServiceImplementationPackage si = this.getClass().getAnnotation(ServiceImplementationPackage.class);
        Pairs p = this.getClass().getAnnotation(Pairs.class);
        for (Pair c : coppie = p.value()) {
            this.insertDataIntoMap(sd.value(), c.key(), si.value(), c.value());
        }
    }

    private void configureWithXML(File xmlFile) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            doc = builder.parse(xmlFile.getAbsolutePath());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String serviceDeclarationPackage = null;
        String serviceImplementationPackage = null;
        NodeList keys = null;
        NodeList values = null;
        try {
            XPathExpression expr1 = xpath.compile("/miniDI/ServiceDeclarationPackage/text()");
            serviceDeclarationPackage = ((Node)expr1.evaluate(doc, XPathConstants.NODE)).getNodeValue().trim();
            expr1 = xpath.compile("/miniDI/ServiceImplementationPackage/text()");
            serviceImplementationPackage = ((Node)expr1.evaluate(doc, XPathConstants.NODE)).getNodeValue().trim();
            expr1 = xpath.compile("/miniDI/Pairs/Pair/key/text()");
            keys = (NodeList)expr1.evaluate(doc, XPathConstants.NODESET);
            expr1 = xpath.compile("/miniDI/Pairs/Pair/value/text()");
            values = (NodeList)expr1.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (int i = 0; i < keys.getLength(); ++i) {
            this.insertDataIntoMap(serviceDeclarationPackage, keys.item(i).getNodeValue().trim(), serviceImplementationPackage, values.item(i).getNodeValue().trim());
        }
    }

    private void insertDataIntoMap(String serviceDeclarationPackage, String key, String serviceImplementationPackage, String value) {
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        try {
            keyClass = Class.forName(serviceDeclarationPackage + "." + key);
            valueClass = Class.forName(serviceImplementationPackage + "." + value);
            System.out.println("Found mapping:\n==>" + serviceDeclarationPackage + "." + key + "==>" + serviceImplementationPackage + "." + value);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AbstractConfigurator.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.createMapping(keyClass, valueClass);
    }

    private <T> void createMapping(Class<T> baseClass, Class<? extends T> subClass) {
        this.classMap.put(baseClass, subClass.asSubclass(baseClass));
    }

    <T> Class<? extends T> getMapping(Class<T> type) {
        Class<?> implementation = this.classMap.get(type);
        if (implementation == null) {
            throw new IllegalArgumentException("Couldn't find the mapping for : " + type);
        }
        return implementation;
    }
}

