/*
 * Decompiled with CFR 0.152.
 */
package miniDI.framework;

import java.lang.reflect.Constructor;
import miniDI.framework.AbstractConfigurator;
import miniDI.framework.annotations.Inject;

public class MiniDIFramework {
    private AbstractConfigurator configurator;

    MiniDIFramework(AbstractConfigurator configurator) {
        this.configurator = configurator;
    }

    public Object injectDependencies(Class clazz) throws Exception {
        if (clazz != null) {
            int index = 0;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!constructor.isAnnotationPresent(Inject.class) || index != 0) continue;
                ++index;
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                Object[] objArr = new Object[parameterTypes.length];
                int i = 0;
                for (Class<?> c : parameterTypes) {
                    Class<?> dependency = this.configurator.getMapping(c);
                    if (!c.isAssignableFrom(dependency)) continue;
                    objArr[i++] = dependency.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                Object resObj = clazz.getConstructor(parameterTypes).newInstance(objArr);
                return resObj;
            }
        }
        return null;
    }
}

