package miniDI.Demo;

import miniDI.Demo.configurator.Configurator;
import miniDI.framework.MiniDIFrameworkFactory;
import miniDI.framework.MiniDIFramework;

public class App {

    public static void main(String[] args) throws Exception {
        // FRAMEWORK INSTANCIATION
        // framework constructor cannot be created outsisde its package!
        //MiniDIFramework g=new MiniDIFramework(new Configurator()); 
        MiniDIFramework f = MiniDIFrameworkFactory.getMiniDIFramework(new Configurator());
        // framework constructor canonly be instanciated once!
        //MiniDIFramework h = MiniDIFrameworkFactory.getMiniDIFramework(new Configurator());

        Client client = (Client) f.injectDependencies(Client.class);
        if (client==null) {
            System.err.println("Client has not been correctly instanciated");
            System.exit(1);
        }
        client.doSomething();
    }
}
