package miniDI.framework;
import java.lang.reflect.Constructor;
import miniDI.framework.annotations.Inject;

//import miniDI.framework.module.IMapper;

public class MiniDIFramework {
        private AbstractConfigurator module;
       
        MiniDIFramework(AbstractConfigurator module) {
                this.module = module;           
        }
        
        @SuppressWarnings("unchecked")
        public Object injectDependencies(Class klass) throws Exception {          
                if(klass != null) {                     
                        boolean flag = true;
                        int index = 0;
                        
                        for(Constructor constructor: klass.getConstructors()) {                         
                                if(constructor.isAnnotationPresent(Inject.class)) {
                                        if(flag && index == 0) { //To restrict to only one constructor injection
                                                flag = false;
                                                index++;
                                                                                                
                                                Class[] parameterTypes = constructor.getParameterTypes();
                                                Object[] objArr = new Object[parameterTypes.length];
                                                
                                                int i = 0;
                                                
                                                for(Class c : parameterTypes) {
                                                        Class dependency = module.getMapping(c);
                                                                                                                                                                                                                        
                                                        if(c.isAssignableFrom(dependency)) {                                                            
                                                                objArr[i++] = dependency.getConstructor().newInstance();                                                
                                                        }
                                                }
                                                
                                                Object resObj = klass.getConstructor(parameterTypes).newInstance(objArr);                                               
                                                
                                                return resObj;
                                        }                                       
                                }
                        }
                }
                
                return null;            
        }
}

