package miniDI.Demo;

import miniDI.Demo.configurator.Configurator;
import miniDI.Demo.configurator.Configurator2;
import miniDI.framework.MultiInstanceMiniDIFrameworkFactory;
import miniDI.framework.MiniDIFrameworkFactory;
import miniDI.framework.MiniDIFramework;

public class App {

    public static void main(String[] args) throws Exception {
        // FRAMEWORK INSTANCIATION
        // framework constructor cannot be created outsisde its package!
        //MiniDIFramework g=new MiniDIFramework(new Configurator()); 
        MiniDIFramework f = MiniDIFrameworkFactory.getMiniDIFramework(new Configurator());
        //MiniDIFramework f = MultiInstanceMiniDIFrameworkFactory.getMiniDIFramework(new Configurator());
        // framework constructor canonly be instanciated once!
        //MiniDIFramework h = MiniDIFrameworkFactory.getMiniDIFramework(new Configurator());
        //MiniDIFramework f = MultiInstanceMiniDIFrameworkFactory.getMiniDIFramework(new Configurator());

        Client client = (Client) f.injectDependencies(Client.class);
        if (client==null) {
            System.err.println("Client has not been correctly instanciated");
            System.exit(1);
        }
        client.doSomething();
        // =====================================================================
        MiniDIFramework f2 = MiniDIFrameworkFactory.getMiniDIFramework(new Configurator2());        
        //MiniDIFramework f2 = MultiInstanceMiniDIFrameworkFactory.getMiniDIFramework(new Configurator2());        
        Client2 client2 = (Client2) f2.injectDependencies(Client2.class);
        if (client2==null) {
            System.err.println("Client2 has not been correctly instanciated");
            System.exit(1);
        }
        client2.doSomething();
    }
}
