package miniDI.Demo.configurator;

import miniDI.framework.AbstractConfigurator;
import miniDI.framework.annotations.Pairs;
import miniDI.framework.annotations.Pair;
import miniDI.framework.annotations.ServiceDeclarationPackage;
import miniDI.framework.annotations.ServiceImplementationPackage;


@ServiceDeclarationPackage("miniDI.Demo.serviceDeclaration")
@ServiceImplementationPackage("miniDI.Demo.serviceImplementation")
@Pairs({
    @Pair(key="iReader", value="ReaderFromFile"),
    @Pair(key="iWriter", value="WriterToFile"),
    //@Pair(key="iReader", value="ReaderFromMemory"),
    //@Pair(key="iWriter", value="WriterToMemory")     
})
/**
 * The Configurator class must extend Abstract Configurator and provide (via annotation)
 * the mappings between the declared service and the implemented services 
 */
public class Configurator extends AbstractConfigurator {
}