package miniDI.framework;

import java.lang.reflect.Constructor;
import miniDI.framework.annotations.Inject;

//import miniDI.framework.module.IMapper;
public class MiniDIFramework {

    private AbstractConfigurator configurator;

    MiniDIFramework(AbstractConfigurator configurator) {
        this.configurator = configurator;
    }

    @SuppressWarnings("unchecked")
    public Object injectDependencies(Class clazz) throws Exception {
        if (clazz != null) {
            int index = 0;

            // finds which constructor of the given class (input parameter) is annotated,
            // checks its parameter types,
            // finds an implementation bound to each parameter type,
            // creates an instance of the implementation,
            // uses the chosen constructor and the implementation instances to create 
            //     an object of the given class ("injects" into the given class
            //     the implementations specified by the Configurator
            //     and returns it.
            for (Constructor constructor : clazz.getConstructors()) {
                if (constructor.isAnnotationPresent(Inject.class)) {
                    if (index == 0) { //restrict to only one constructor injection
                        index++;

                        Class[] parameterTypes = constructor.getParameterTypes();
                        Object[] objArr = new Object[parameterTypes.length];

                        int i = 0;

                        for (Class c : parameterTypes) {
                            Class dependency = configurator.getMapping(c);

                            if (c.isAssignableFrom(dependency)) {
                                objArr[i++] = dependency.getConstructor().newInstance();
                            }
                        }

                        Object resObj = clazz.getConstructor(parameterTypes).newInstance(objArr);

                        return resObj;
                    }
                }
            }
        }
        // if class was null, or no annotated constructor was found return null
        return null;
    }
}
