/**
 * Services used by Digpedia application
 * Require: action.js
 * @author Massimiliano Battan
 * @version 2.1
 * 
 **/

var serviceType = "Database";
var backEnd = "http://localhost:8084/FindAsREST/webresources/";

var findAsServices = angular.module('findasservices', ['ngResource']);

/*
 * Interceptor needed to add support of "status" injection in response angular objects
 * Set as well a finite timeout for requests
 */
findAsServices.factory("baseInterceptor", ["$q", function ($q) {
        return {
            'request': function (config) {
                //set timeout for all request
                config.timeout = 60000;
                return config;
            },
            'requestError': function (rejection) {
                return $q.reject(rejection);
            },
            'response': function (response) {
                if (response.data != undefined) {
                    response.data.$httpstatus = response.status;//put the status in the response object!!
                }
                return response;
            },
            'responseError': function (rejection) {
                return $q.reject(rejection);
            }
        };
    }]);

/*
 * Register the interceptor
 */
findAsServices.config(["$httpProvider", function ($httpProvider) {
        $httpProvider.interceptors.push("baseInterceptor");
    }]);

/*
 * Wikipage base service
 */
findAsServices.factory('propertyservice', ['$resource',
    function ($resource) {
        return $resource(backEnd+'wikipage/' + resource,
                {"locale": locale,
                    "servicetype": serviceType},
        {
            getProperty: {method: 'GET',
                responseType: "json"}
        });

    }]);

/*
 * Dbpedia base service
 */
findAsServices.factory('queryService', ['$resource', '$filter', function ($resource, $filter) {


        return {
            queryDbpediaProps: function () {
                return $resource(backEnd+'dbpedia/dbpediaprops/' + resource,
                        {"locale": locale}, {
                    getDbpedia: {method: 'GET', responseType: 'json'}
                });
            },
            queryDbpediaInner: function () {
                return $resource(backEnd+'dbpedia/dbpediaclass/' + resource,
                        {"locale": locale}, {
                    get: {method: 'GET', responseType: 'json'}
                });
            },
            getQueryResult: function () {
                return $resource(backEnd+'sparql/query/',
                        {"locale": locale,
                            "resource": resource},
                {
                    post: {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    }
                });

            }

        };

    }]);
