package lesson02.example.com.lesson02.Adapters;

import android.content.Context;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;

import lesson02.example.com.lesson02.Article;
import lesson02.example.com.lesson02.R;

public class ItemsComplexAdapter extends ArrayAdapter<Article> {

    private ArrayList<Article> mArticles;
    private Context mContext = null;
    private int mLayout;

    public ItemsComplexAdapter(Context context, int layoutId,	ArrayList<Article> articles) {
        super(context, layoutId, articles);
        mArticles = articles;
        mContext = context;
        mLayout = layoutId;
    }


    @Override
    public View getView(int position, View view, ViewGroup parent) {
        LayoutInflater vi = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        view = vi.inflate(mLayout, null);

        Article article = mArticles.get(position);

        ImageView articleImage = (ImageView) view
                .findViewById(R.id.articleImage);
        articleImage.setImageBitmap(article.getImage());

        TextView articleDescription = (TextView) view
                .findViewById(R.id.articleDesc);
        articleDescription.setText(article.getArticleName());

        return view;
    }
}