package lesson02.example.com.lesson02;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;

import lesson02.example.com.lesson02.Adapters.ItemsComplexAdapter;
import lesson02.example.com.lesson02.Adapters.ItemsSimpleAdapter;


public class ListActivity extends ActionBarActivity {

        @Override
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            setContentView(R.layout.activity_list);

            // retrieve the intent that started the current activity
            Intent intent = getIntent();

            String passedParameter = intent.getStringExtra(getPackageName()+ ".insertedText");

            int numberOfItems = intent.getIntExtra(getPackageName() + ".items", 1);
            boolean isComplexList = intent.getBooleanExtra(getPackageName()	+ ".isComplexList", false);

            TextView passedText = (TextView) findViewById(R.id.passedString);
            passedText.setText(R.string.welcome);
            passedText.append(" " + passedParameter);

            ListView view = (ListView) findViewById(R.id.list);

            if (isComplexList) {

                //Show the images for each beer!
                final ArrayList<Article> articleList = PrepareArticleList(numberOfItems);
                view.setAdapter(new ItemsComplexAdapter(this, R.layout.listrowlayout, articleList));
                view.setOnItemClickListener(new AdapterView.OnItemClickListener() {

                    public void onItemClick(AdapterView<?> parent, View view,int position, long id) {
                        Toast.makeText(getApplicationContext(),
                                articleList.get(position).getArticleName(),
                                Toast.LENGTH_LONG).show();
                    }
                });

            } else {
                //Show only the names
                ArrayList<String> articleList = PrepareStringList(numberOfItems);
                view.setAdapter(new ItemsSimpleAdapter(this, R.layout.listrowlayout, articleList));
            }
        }


        /**
         *
         * Utility methods, we are going to use these methods in order to generate a
         * list of items
         *
         **/
        private ArrayList<Article> PrepareArticleList(int numberOfItems) {
            ArrayList<Article> articleList = new ArrayList<Article>();
            for (int i = 0; i < numberOfItems; i++) {
                Article article = new Article();
                article.setArticleName("Article " + i);

                Bitmap image = BitmapFactory.decodeResource(this.getResources(),
                        R.drawable.articleimg);

                article.setImage(image);
                articleList.add(article);

            }
            return articleList;
        }

        private ArrayList<String> PrepareStringList(int numberOfItems) {
            ArrayList<String> articleList = new ArrayList<String>();
            for (int i = 0; i < numberOfItems; i++)
                articleList.add("Article " + i);

            return articleList;
        }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_list, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
