package lesson02.example.com.lesson02;

import android.app.ListActivity;
import android.content.Intent;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;


public class MainActivity extends ActionBarActivity {

    private int MAX_ITEMS = 50;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        final EditText inputName = (EditText) findViewById(R.id.inputName);
        final CheckBox isComplexList = (CheckBox) findViewById(R.id.isComplexList);
        final EditText numberOfArticles = (EditText) findViewById(R.id.numberOfArticles);

        TextView submit = (TextView) findViewById(R.id.instruction4);
        submit.setOnClickListener(new View.OnClickListener() {

            public void onClick(View v) {

                int articlesNumber = 0;

                // Let us create a new Intent so that we could start a new
                // Activity
                Intent startListActivity = new Intent(MainActivity.this,
                        ListActivity.class);

                String inputText = inputName.getText().toString();

                if (isComplexList.isChecked()) {
                    startListActivity.putExtra(getPackageName() + ".isComplexList",
                            true);
                }

                try {

                    articlesNumber = Integer.parseInt(numberOfArticles
                            .getText().toString());

                    if (articlesNumber == 0)
                        articlesNumber = 1;

                    if (articlesNumber > MAX_ITEMS) {
                        articlesNumber = MAX_ITEMS;
                    }

                } catch (NumberFormatException nfe) {
                    articlesNumber = 1;
                }

                startListActivity.putExtra(getPackageName() + ".items",
                        articlesNumber);

                if (inputText.length() > 0) {

                    startListActivity.putExtra(getPackageName()
                            + ".insertedText", inputText);

                    startActivity(startListActivity);
                } else {
                    Toast.makeText(MainActivity.this,
                            getString(R.string.EmptyNameNotAllowed),
                            Toast.LENGTH_LONG).show();
                }
            }
        });

        TextView sillyList = (TextView) findViewById(R.id.instruction5);
        sillyList.setOnClickListener(new View.OnClickListener() {

            public void onClick(View v) {
                Intent sillyIntent = new Intent(MainActivity.this, SillyAdapter.class);
                startActivity(sillyIntent);

            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
