/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.ling1.esameSet14;

import it.unitn.disi.ling1.esameSet14.Salvadanaio;
import it.unitn.disi.ling1.esameSet14.Spinbar;
import it.unitn.disi.ling1.esameSet14.Title;
import it.unitn.disi.ling1.esameSet14.ValueBox;
import java.util.Random;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class SlotMachine
extends Application {
    public static final int NUM_MONETE = 3;
    public static final int NUM_SPINNERS = 3;
    public static final int NUM_TIPI = 6;
    public static final int NPOINTS_PER_MONETA = 100;
    public static final int COSTO_PARTITA = 100;
    public static final int PUNTI_PER_PARTITA = 128;
    public static Random randomGenerator = new Random(System.currentTimeMillis());
    Stage mainWindow = null;
    ValueBox creditBox = null;
    ValueBox punteggioBox = null;
    Spinbar spinbar = null;
    Salvadanaio salvadanaio = null;

    public boolean payPoints() {
        int punti = this.punteggioBox.getValue();
        if (punti == 0) {
            return false;
        }
        this.punteggioBox.setValue(punti / 2);
        return true;
    }

    public void declareVictory() {
        int points = this.punteggioBox.getValue();
        this.punteggioBox.setValue(0);
        this.showPopup("Hai vinto!");
        this.creditBox.incrementValue(points * 100);
    }

    BorderPane prepareSceneContent() {
        BorderPane border = new BorderPane();
        Title g = new Title();
        border.setTop((Node)g);
        BorderPane.setAlignment((Node)g, (Pos)Pos.CENTER);
        this.salvadanaio = new Salvadanaio(this);
        border.setRight((Node)this.salvadanaio);
        HBox buttonbar = new HBox();
        MyButton spinButton = new MyButton("Spin", true, new ListenerSpinButton());
        MyButton payButton = new MyButton("Pay", true, new ListenerPayButton());
        MyButton nuovaPartitaButton = new MyButton("Nuova Partita", false, new ListenerNuovaPartitaButton());
        buttonbar.getChildren().addAll((Object[])new Node[]{nuovaPartitaButton, spinButton, payButton});
        buttonbar.setSpacing(40.0);
        buttonbar.setAlignment(Pos.CENTER);
        border.setBottom((Node)buttonbar);
        VBox centralBox = new VBox();
        centralBox.setAlignment(Pos.CENTER);
        centralBox.setSpacing(40.0);
        centralBox.setPadding(new Insets(0.0, 0.0, 0.0, 100.0));
        this.spinbar = new Spinbar(this);
        this.spinbar.setAlignment(Pos.CENTER);
        HBox boxContatori = new HBox();
        this.creditBox = new ValueBox("Credito", payButton);
        this.punteggioBox = new ValueBox("Punteggio", spinButton);
        boxContatori.getChildren().addAll((Object[])new Node[]{this.creditBox, this.punteggioBox});
        boxContatori.setAlignment(Pos.CENTER);
        boxContatori.setSpacing(40.0);
        centralBox.getChildren().addAll((Object[])new Node[]{this.spinbar, boxContatori});
        border.setCenter((Node)centralBox);
        this.reset();
        return border;
    }

    void reset() {
        this.creditBox.reset();
        this.punteggioBox.reset();
        this.salvadanaio.initialize();
        this.spinbar.initialize();
    }

    public void showPopup(String message) {
        Label label = new Label(message);
        label.setAlignment(Pos.CENTER);
        label.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)20.0));
        Scene sc = new Scene((Parent)label, 500.0, 200.0);
        Stage stage = new Stage();
        stage.setScene(sc);
        stage.setX(100.0);
        stage.setY(100.0);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)this.mainWindow);
        stage.show();
    }

    public void start(Stage primaryStage) {
        Scene scene = new Scene((Parent)this.prepareSceneContent(), 800.0, 500.0);
        this.mainWindow = primaryStage;
        primaryStage.setTitle("Slot Machine");
        primaryStage.setScene(scene);
        primaryStage.centerOnScreen();
        primaryStage.show();
    }

    public static void main(String[] args) {
        SlotMachine.launch((String[])args);
    }

    class ListenerSpinButton
    implements EventHandler {
        ListenerSpinButton() {
        }

        public void handle(Event t) {
            SlotMachine.this.spinbar.spinAll();
        }
    }

    class ListenerPayButton
    implements EventHandler {
        ListenerPayButton() {
        }

        public void handle(Event t) {
            int euro = SlotMachine.this.creditBox.getValue() / 100;
            String message = "Hai vinto " + euro + " Euro";
            SlotMachine.this.showPopup(message);
            SlotMachine.this.reset();
        }
    }

    class ListenerNuovaPartitaButton
    implements EventHandler {
        ListenerNuovaPartitaButton() {
        }

        public void handle(Event t) {
            if (SlotMachine.this.creditBox.getValue() < 100) {
                SlotMachine.this.showPopup("Non hai credito sufficente");
            } else {
                SlotMachine.this.spinbar.initialize();
                SlotMachine.this.creditBox.incrementValue(-100);
                SlotMachine.this.punteggioBox.setValue(128);
            }
        }
    }

    class MyButton
    extends Button {
        MyButton(String label, boolean isDisabled, EventHandler listener) {
            super(label);
            this.setMinSize(50.0, 50.0);
            this.setDisable(isDisabled);
            this.addEventHandler(ActionEvent.ACTION, listener);
        }
    }
}

