/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.ling1.esameSet14;

import it.unitn.disi.ling1.esameSet14.Simbolo;
import it.unitn.disi.ling1.esameSet14.SlotMachine;
import javafx.animation.FadeTransition;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.util.Duration;

public class Spinbar
extends HBox {
    Simbolo[] simbolo = new Simbolo[3];
    EventHandler symbolHandler = new SymbolListener();
    SlotMachine sm = null;

    public Spinbar(SlotMachine sm) {
        this.setAlignment(Pos.CENTER);
        this.setSpacing(10.0);
        this.sm = sm;
        this.initialize();
    }

    public void initialize() {
        this.getChildren().clear();
        for (int i = 0; i < 3; ++i) {
            int tipo = SlotMachine.randomGenerator.nextInt(6);
            this.simbolo[i] = new Simbolo(this.symbolHandler, tipo);
        }
        this.getChildren().addAll((Object[])this.simbolo);
        if (this.areSymbolsEqual()) {
            this.initialize();
        }
    }

    public boolean areSymbolsEqual() {
        for (int i = 1; i < 3; ++i) {
            if (this.simbolo[0].getId().equals(this.simbolo[i].getId())) continue;
            return false;
        }
        return true;
    }

    public void spinElementWithoutAnimation(int i) {
        int tipo = SlotMachine.randomGenerator.nextInt(6);
        this.simbolo[i] = new Simbolo(this.symbolHandler, tipo);
        System.out.println("replace simbolo " + i);
        this.getChildren().remove(i);
        this.getChildren().add(i, (Object)this.simbolo[i]);
    }

    public void spinElement(final int i) {
        int tipo = SlotMachine.randomGenerator.nextInt(6);
        this.simbolo[i] = new Simbolo(this.symbolHandler, tipo);
        System.out.println("replace simbolo " + i);
        Simbolo vecchioSimbolo = (Simbolo)((Object)this.getChildren().get(i));
        Duration SEC_1 = Duration.millis((double)500.0);
        FadeTransition disappear = new FadeTransition(SEC_1, (Node)vecchioSimbolo);
        disappear.setFromValue(1.0);
        disappear.setToValue(0.0);
        final FadeTransition appear = new FadeTransition(SEC_1, (Node)this.simbolo[i]);
        appear.setFromValue(0.0);
        appear.setToValue(1.0);
        disappear.setOnFinished(new EventHandler(){

            public void handle(Event t) {
                Spinbar.this.getChildren().remove(i);
                Spinbar.this.simbolo[i].setOpacity(0.0);
                Spinbar.this.getChildren().add(i, (Object)Spinbar.this.simbolo[i]);
                appear.play();
            }
        });
        disappear.play();
    }

    public void spinAll() {
        if (!this.sm.payPoints()) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.spinElement(i);
        }
        if (this.areSymbolsEqual()) {
            this.sm.declareVictory();
        }
    }

    class SymbolListener
    implements EventHandler {
        SymbolListener() {
        }

        public void handle(Event t) {
            System.out.println("Symbol event " + t);
            if (!Spinbar.this.sm.payPoints()) {
                return;
            }
            Simbolo s = (Simbolo)((Object)t.getSource());
            for (int i = 0; i < 3; ++i) {
                if (s != Spinbar.this.simbolo[i]) continue;
                Spinbar.this.spinElement(i);
            }
            t.consume();
            if (Spinbar.this.areSymbolsEqual()) {
                Spinbar.this.sm.declareVictory();
            }
        }
    }
}

